<?php
    use App\Helpers\MenuHelper;
    
    $menuItems = MenuHelper::getMenuItems();
    $user = Auth::user();
    $userRole = $user->tipo == '1' ? 'superadmin' : ($user->roles ?? 'master');
    
    // Logo dinâmico - usar ID do usuário atual
    $userId = $user->id;
    $logoPathLight = "master/img/logo_light_{$userId}.png";
    $logoPathDark = "master/img/logo_dark_{$userId}.png";
    
    // Verificar se os arquivos existem
    $localFilePathLight = public_path($logoPathLight);
    $localFilePathDark = public_path($logoPathDark);
    
    $defaultLogoLight = asset('master/img/logo_light_88.png');
    $defaultLogoDark = asset('master/img/logo_dark_88.png');
    
    // Usar logo personalizada se existir, senão usar padrão
    $logoUrlLight = file_exists($localFilePathLight) ? asset($logoPathLight) : $defaultLogoLight;
    $logoUrlDark = file_exists($localFilePathDark) ? asset($logoPathDark) : $defaultLogoDark;
    
    // Verificar se é funcionário e buscar as funções habilitadas
    $funcoes = [];
    if (session('is_funcionario') && session('funcionario_id')) {
        $funcionario = \App\Models\Funcionario::find(session('funcionario_id'));
        if ($funcionario && $funcionario->funcoes) {
            $funcoes = explode(',', $funcionario->funcoes);
            $funcoes = array_map('trim', $funcoes);
        }
        $userRole = 'funcionario';
    }
?>

<aside class="sidebar">
    <button type="button" class="sidebar-close-btn">
        <iconify-icon icon="radix-icons:cross-2"></iconify-icon>
    </button>
    <div>
        <a href="<?php echo e(route('dashboard')); ?>" class="sidebar-logo">
            <?php
                // Logo dinâmico baseado no ID do usuário (igual ao legado)
                $userId = $user->id;
                $logoPath = "master/img/logo{$userId}.png";
                $logoUrl = file_exists(public_path($logoPath)) ? asset($logoPath) : asset('master/img/logo88.png');
            ?>
            <img src="<?php echo e($logoUrl); ?>" alt="site logo" class="light-logo">
            <img src="<?php echo e($logoUrl); ?>" alt="site logo" class="dark-logo">
            <img src="<?php echo e($logoUrl); ?>" alt="site logo" class="logo-icon">
        </a>
    </div>
    <div class="sidebar-menu-area">
        <ul class="sidebar-menu" id="sidebar-menu">
            <?php $__currentLoopData = $menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $temSubmenu = isset($item['submenu']);
                    $temGroupTitle = isset($item['group_title']);
                ?>

                <?php if($temSubmenu): ?>
                    <!-- MENU COM SUBMENU (tipo: submenu) -->
                    <li class="dropdown">
                        <a href="<?php echo e($item['path']); ?>">
                            <iconify-icon icon="<?php echo e($item['icon']); ?>" class="menu-icon"></iconify-icon>
                            <span><?php echo e($item['name']); ?></span>
                        </a>
                        <ul class="sidebar-submenu">
                            <?php $__currentLoopData = $item['submenu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e($submenu['path']); ?>">
                                        <i class="ri-circle-fill circle-icon <?php echo e($submenu['colorIcon'] ?? 'text-primary-600'); ?> w-auto"></i>
                                        <?php echo e($submenu['name']); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>

                <?php elseif($temGroupTitle): ?>
                    <?php
                        // Verificar se o grupo deve ser visível
                        $groupVisible = false;
                        foreach ($item['group_title'] as $groupItem) {
                            if ($userRole == "superadmin" || !isset($groupItem['funcao']) || in_array($groupItem['funcao'], $funcoes)) {
                                $groupVisible = true;
                                break;
                            }
                        }
                    ?>
                    <?php if($groupVisible): ?>
                        <!-- MENU COM GRUPO (tipo: group_title) - Estrutura igual ao legado com dropdown -->
                        <li class="dropdown">
                            <a href="javascript:void(0)">
                                <iconify-icon icon="<?php echo e($item['icon']); ?>" class="menu-icon"></iconify-icon>
                                <span><?php echo e($item['name']); ?></span>
                            </a>
                            <ul class="sidebar-submenu">
                                <?php $__currentLoopData = $item['group_title']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        // Verificar se o item deve ser visível
                                        $itemVisible = false;
                                        if ($userRole == "superadmin" || !isset($groupItem['funcao']) || in_array($groupItem['funcao'], $funcoes)) {
                                            $itemVisible = true;
                                        }
                                    ?>
                                    <?php if($itemVisible): ?>
                                        <li>
                                            <a href="<?php echo e($groupItem['path']); ?>">
                                                <iconify-icon icon="<?php echo e($groupItem['icon']); ?>" class="menu-icon"></iconify-icon>
                                                <span><?php echo e($groupItem['name']); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </li>
                    <?php endif; ?>

                <?php else: ?>
                    <?php
                        // Verificar se o item deve ser visível
                        $itemVisible = false;
                        if ($userRole == "superadmin" || !isset($item['funcao']) || in_array($item['funcao'], $funcoes)) {
                            $itemVisible = true;
                        }
                    ?>
                    <?php if($itemVisible): ?>
                        <!-- ITEM SIMPLES -->
                        <li>
                            <a href="<?php echo e($item['path']); ?>">
                                <iconify-icon icon="<?php echo e($item['icon']); ?>" class="menu-icon"></iconify-icon>
                                <span><?php echo e($item['name']); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</aside>

<script>
// Script para ajustar o logo-icon de acordo com o modo atual
document.addEventListener('DOMContentLoaded', function() {
    const logoIcon = document.querySelector('.logo-icon');
    const lightLogoUrl = '<?php echo e($logoUrlLight); ?>';
    const darkLogoUrl = '<?php echo e($logoUrlDark); ?>';
    
    if (!logoIcon) return;
    
    // Função para verificar se está no modo escuro
    function isDarkMode() {
        return document.documentElement.getAttribute('data-theme') === 'dark' || 
               document.body.classList.contains('dark-mode');
    }
    
    // Função para atualizar o ícone da logo
    function updateLogoIcon() {
        if (isDarkMode()) {
            logoIcon.src = darkLogoUrl;
        } else {
            logoIcon.src = lightLogoUrl;
        }
    }
    
    // Atualizar na carga inicial
    updateLogoIcon();
    
    // Observar mudanças no atributo data-theme
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'attributes' && mutation.attributeName === 'data-theme') {
                updateLogoIcon();
            }
        });
    });
    
    // Observar mudanças no html
    observer.observe(document.documentElement, { attributes: true, attributeFilter: ['data-theme'] });
    
    // Observar mudanças na classe dark-mode do body
    const bodyObserver = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                updateLogoIcon();
            }
        });
    });
    
    bodyObserver.observe(document.body, { attributes: true, attributeFilter: ['class'] });
});

// Garantir que os submenus comecem fechados
document.addEventListener('DOMContentLoaded', function() {
    // Esconder todos os submenus por padrão
    var submenus = document.querySelectorAll('.sidebar-submenu');
    submenus.forEach(function(submenu) {
        submenu.style.display = 'none';
    });
});
</script>
<?php /**PATH D:\Documentos\Desktop\gestor1.1.0\laravel-gestor\resources\views/layouts/sidebar.blade.php ENDPATH**/ ?>