<!-- Modal Calculadora -->
<div class="modal fade" id="modalCalculadora" tabindex="-1" aria-labelledby="modalCalculadoraLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalCalculadoraLabel">Calculadora</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="calculator">
                    <div class="calculator-display">
                        <input type="text" id="calc-display" class="form-control text-end" readonly value="0" style="font-size: 2rem; height: 60px;">
                    </div>
                    <div class="calculator-buttons mt-3">
                        <div class="row g-2">
                            <div class="col-3"><button class="btn btn-secondary w-100" onclick="calcClear()">C</button></div>
                            <div class="col-3"><button class="btn btn-secondary w-100" onclick="calcBackspace()">⌫</button></div>
                            <div class="col-3"><button class="btn btn-secondary w-100" onclick="calcOperator('/')">/</button></div>
                            <div class="col-3"><button class="btn btn-secondary w-100" onclick="calcOperator('*')">×</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('7')">7</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('8')">8</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('9')">9</button></div>
                            <div class="col-3"><button class="btn btn-secondary w-100" onclick="calcOperator('-')">-</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('4')">4</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('5')">5</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('6')">6</button></div>
                            <div class="col-3"><button class="btn btn-secondary w-100" onclick="calcOperator('+')">+</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('1')">1</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('2')">2</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('3')">3</button></div>
                            <div class="col-3"><button class="btn btn-primary w-100" onclick="calcEquals()" style="height: 100%;">=</button></div>
                            <div class="col-6"><button class="btn btn-light w-100" onclick="calcNumber('0')">0</button></div>
                            <div class="col-3"><button class="btn btn-light w-100" onclick="calcNumber('.')">.</button></div>
                            <div class="col-3"><button class="btn btn-primary w-100" onclick="calcEquals()">=</button></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let calcValue = '0';
let calcOperator = null;
let calcWaitingForOperand = false;

function calcUpdateDisplay() {
    document.getElementById('calc-display').value = calcValue;
}

function calcNumber(num) {
    if (calcWaitingForOperand) {
        calcValue = num;
        calcWaitingForOperand = false;
    } else {
        calcValue = calcValue === '0' ? num : calcValue + num;
    }
    calcUpdateDisplay();
}

function calcOperator(op) {
    const inputValue = parseFloat(calcValue);
    
    if (calcOperator === null) {
        calcOperator = op;
        calcValue = String(inputValue);
    } else {
        const result = calcPerformCalculation();
        calcValue = String(result);
        calcOperator = op;
    }
    
    calcWaitingForOperand = true;
    calcUpdateDisplay();
}

function calcPerformCalculation() {
    const inputValue = parseFloat(calcValue);
    
    if (calcOperator === '+') {
        return calcOperator + inputValue;
    } else if (calcOperator === '-') {
        return calcOperator - inputValue;
    } else if (calcOperator === '*') {
        return calcOperator * inputValue;
    } else if (calcOperator === '/') {
        return calcOperator / inputValue;
    }
    
    return inputValue;
}

function calcEquals() {
    const inputValue = parseFloat(calcValue);
    
    if (calcOperator && !calcWaitingForOperand) {
        const result = calcPerformCalculation();
        calcValue = String(result);
        calcOperator = null;
        calcWaitingForOperand = true;
        calcUpdateDisplay();
    }
}

function calcClear() {
    calcValue = '0';
    calcOperator = null;
    calcWaitingForOperand = false;
    calcUpdateDisplay();
}

function calcBackspace() {
    if (calcValue.length > 1) {
        calcValue = calcValue.slice(0, -1);
    } else {
        calcValue = '0';
    }
    calcUpdateDisplay();
}
</script>

<?php /**PATH D:\Documentos\Desktop\gestor1.1.0\laravel-gestor\resources\views/pdv/modals/calculadora.blade.php ENDPATH**/ ?>