<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ClienteController;
use App\Http\Controllers\CategoriaController;
use App\Http\Controllers\FinanceiroController;
use App\Http\Controllers\MensagemController;
use App\Http\Controllers\PlanoController;
use App\Http\Controllers\ConfiguracaoController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/
Route::get('/clear-all', function () {
    \Artisan::call('cache:clear');
    \Artisan::call('config:clear');
    \Artisan::call('view:clear');
    \Artisan::call('route:clear');
    // system('composer dump-autoload');
    return redirect()->back();
})->name('clear');


// Rotas públicas
Route::get('/', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::get('/sair', [AuthController::class, 'logout'])->name('logout');

// Webhooks (sem autenticação - recebem notificações externas)
// Mercado Pago pode usar GET ou POST
Route::match(['get', 'post'], '/webhook/mercadopago', [\App\Http\Controllers\WebhookController::class, 'mercadoPago'])->name('webhook.mercadopago');
Route::post('/webhook/asaas', [\App\Http\Controllers\WebhookController::class, 'asaas'])->name('webhook.asaas');
Route::post('/webhook/gerencianet', [\App\Http\Controllers\WebhookController::class, 'gerencianet'])->name('webhook.gerencianet');
Route::post('/webhook/paghiper', [\App\Http\Controllers\WebhookController::class, 'paghiper'])->name('webhook.paghiper');

// Criar conta e recuperar senha
Route::get('/criar_conta', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/criar_conta', [AuthController::class, 'register']);
Route::get('/recuperar_senha', [AuthController::class, 'showRecoverForm'])->name('recover');
Route::post('/recuperar_senha', [AuthController::class, 'recover']);

// Rotas autenticadas
Route::middleware(['auth', 'check.license', 'check.subscription'])->prefix('master')->group(function () {
    
    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/home', [DashboardController::class, 'index']);
    
    // Categorias
    Route::get('/categorias', [CategoriaController::class, 'index'])->name('categorias.index');
    Route::get('/cad_categoria', [CategoriaController::class, 'create'])->name('categorias.create');
    Route::post('/categorias', [CategoriaController::class, 'store'])->name('categorias.store');
    Route::get('/edit_categoria/{id}', [CategoriaController::class, 'edit'])->name('categorias.edit');
    Route::put('/categorias/{id}', [CategoriaController::class, 'update'])->name('categorias.update');
    Route::delete('/categorias/{id}', [CategoriaController::class, 'destroy'])->name('categorias.destroy');
    
    // Clientes
    Route::get('/clientes', [ClienteController::class, 'index'])->name('clientes.index');
    Route::get('/cad_cliente', [ClienteController::class, 'create'])->name('clientes.create');
    Route::post('/clientes', [ClienteController::class, 'store'])->name('clientes.store');
    Route::get('/ver_cliente/{id}', [ClienteController::class, 'show'])->name('clientes.show');
    Route::get('/edit_cliente/{id}', [ClienteController::class, 'edit'])->name('clientes.edit');
    Route::put('/clientes/{id}', [ClienteController::class, 'update'])->name('clientes.update');
    Route::delete('/clientes/{id}', [ClienteController::class, 'destroy'])->name('clientes.destroy');
    
    // Financeiro - Contas a Receber
    Route::get('/contas_receber', [FinanceiroController::class, 'contasReceber'])->name('financeiro.contas-receber');
    Route::get('/cad_contas', [FinanceiroController::class, 'criarContaReceber'])->name('financeiro.criar-conta-receber');
    Route::post('/contas_receber', [FinanceiroController::class, 'storeContaReceber'])->name('financeiro.store-conta-receber');
    Route::post('/baixar_parcela/{id}', [FinanceiroController::class, 'baixarParcela'])->name('financeiro.baixar-parcela');
    
    // Simulador de Parcelas
    Route::post('/cad_contas_simulador', [FinanceiroController::class, 'simularParcelas'])->name('financeiro.simular-parcelas');
    Route::post('/confirmar_simulacao', [FinanceiroController::class, 'confirmarSimulacao'])->name('financeiro.confirmar-simulacao');
    
    // Financeiro - Contas a Pagar
    Route::get('/contas_pagar', [FinanceiroController::class, 'contasPagar'])->name('financeiro.contas-pagar');
    Route::get('/cad_pagar', [FinanceiroController::class, 'criarContaPagar'])->name('financeiro.criar-conta-pagar');
    Route::post('/contas_pagar', [FinanceiroController::class, 'storeContaPagar'])->name('financeiro.store-conta-pagar');
    Route::post('/baixar_conta/{id}', [FinanceiroController::class, 'baixarContaPagar'])->name('financeiro.baixar-conta-pagar');
    
    // Financeiro - Extrato
    Route::get('/finalizados', [FinanceiroController::class, 'extrato'])->name('financeiro.extrato');
    
    // Financeiro - Contas Vencidas
    Route::get('/contas-vencidas', [FinanceiroController::class, 'contasVencidas'])->name('financeiro.contas-vencidas');
    
    // Financeiro - Ver Detalhes
    Route::post('/ver_financeiro', [FinanceiroController::class, 'verFinanceiro'])->name('financeiro.ver-financeiro');
    
    // Mensagens
    Route::get('/mensagens', [MensagemController::class, 'index'])->name('mensagens.index');
    Route::get('/create_menssage', [MensagemController::class, 'create'])->name('mensagens.create');
    Route::post('/mensagens', [MensagemController::class, 'store'])->name('mensagens.store');
    Route::get('/edit_mensagens/{id}', [MensagemController::class, 'edit'])->name('mensagens.edit');
    Route::put('/mensagens/{id}', [MensagemController::class, 'update'])->name('mensagens.update');
    Route::delete('/mensagens/{id}', [MensagemController::class, 'destroy'])->name('mensagens.destroy');
    
    // Usuários SAAS (somente admin)
    Route::middleware('check.admin')->group(function () {
        Route::get('/usuarios', [\App\Http\Controllers\UsuarioController::class, 'index'])->name('usuarios.index');
        Route::get('/cad_usuario', [\App\Http\Controllers\UsuarioController::class, 'create'])->name('usuarios.create');
        Route::post('/usuarios', [\App\Http\Controllers\UsuarioController::class, 'store'])->name('usuarios.store');
        Route::get('/painel_usuario/{id}', [\App\Http\Controllers\UsuarioController::class, 'show'])->name('usuarios.show');
        Route::get('/edit_usuario/{id}', [\App\Http\Controllers\UsuarioController::class, 'edit'])->name('usuarios.edit');
        Route::put('/usuarios/{id}', [\App\Http\Controllers\UsuarioController::class, 'update'])->name('usuarios.update');
        Route::delete('/usuarios/{id}', [\App\Http\Controllers\UsuarioController::class, 'destroy'])->name('usuarios.destroy');
    });
    
    // Planos
    Route::get('/planos', [PlanoController::class, 'index'])->name('planos.index');
    Route::get('/comprar/{id}', [PlanoController::class, 'comprar'])->name('planos.comprar');
    
    // Planos Admin (somente tipo 1)
    Route::middleware('check.admin')->group(function () {
        Route::get('/planos/admin', [PlanoController::class, 'admin'])->name('planos.admin');
        Route::post('/planos', [PlanoController::class, 'store'])->name('planos.store');
        Route::put('/planos/{id}', [PlanoController::class, 'update'])->name('planos.update');
        Route::delete('/planos/{id}', [PlanoController::class, 'destroy'])->name('planos.destroy');
    });
    
    // Configurações
    Route::get('/configuracoes', [ConfiguracaoController::class, 'index'])->name('configuracoes.index');
    Route::post('/configuracoes', [ConfiguracaoController::class, 'update'])->name('configuracoes.update');
    Route::post('/configuracoes/pagamentos', [ConfiguracaoController::class, 'updatePagamentos'])->name('configuracoes.pagamentos');
    Route::post('/configuracoes/whatsapp', [ConfiguracaoController::class, 'updateWhatsApp'])->name('configuracoes.whatsapp');
    Route::post('/configuracoes/theme', [ConfiguracaoController::class, 'toggleTheme'])->name('configuracoes.toggle-theme');
    Route::post('/configuracoes/background', [ConfiguracaoController::class, 'uploadBackground'])->name('configuracoes.upload-background');
    Route::post('/configuracoes/favicon', [ConfiguracaoController::class, 'uploadFavicon'])->name('configuracoes.upload-favicon');
    Route::post('/configuracoes/test-email', [ConfiguracaoController::class, 'testEmail'])->name('configuracoes.test-email');
    
    // Perfil
    Route::get('/perfil', [ConfiguracaoController::class, 'perfil'])->name('perfil');
    Route::post('/perfil', [ConfiguracaoController::class, 'updatePerfil'])->name('perfil.update');
    
    // WhatsApp
    Route::get('/whatsapp', [\App\Http\Controllers\WhatsAppController::class, 'index'])->name('whatsapp.index');
    Route::post('/whatsapp/connect', [\App\Http\Controllers\WhatsAppController::class, 'connect'])->name('whatsapp.connect');
    Route::post('/whatsapp/disconnect', [\App\Http\Controllers\WhatsAppController::class, 'disconnect'])->name('whatsapp.disconnect');
    Route::get('/whatsapp/status', [\App\Http\Controllers\WhatsAppController::class, 'status'])->name('whatsapp.status');
    
    // Vídeos/Tutoriais
    Route::get('/tutoriais', [\App\Http\Controllers\VideoController::class, 'index'])->name('tutoriais.index');
    Route::get('/videos', [\App\Http\Controllers\VideoController::class, 'index'])->name('videos.index');
    Route::post('/videos', [\App\Http\Controllers\VideoController::class, 'store'])->name('videos.store');
    Route::get('/videos/{id}/edit', [\App\Http\Controllers\VideoController::class, 'edit'])->name('videos.edit');
    Route::put('/videos/{id}', [\App\Http\Controllers\VideoController::class, 'update'])->name('videos.update');
    Route::delete('/videos/{id}', [\App\Http\Controllers\VideoController::class, 'destroy'])->name('videos.destroy');
    
    // Changelog/Update
    Route::get('/update', function () {
        return view('update.index');
    })->name('update');
    
    // Funcionários
    Route::resource('funcionarios', \App\Http\Controllers\FuncionarioController::class);
    Route::get('/cadastrar_funcionario', [\App\Http\Controllers\FuncionarioController::class, 'index'])->name('funcionarios.index'); // Alias para compatibilidade com legado
    
    // Comissões
    Route::get('/comissoes', [\App\Http\Controllers\ComissaoController::class, 'index'])->name('comissoes.index');
    Route::get('/comissoes/funcionario/{funcionario}', [\App\Http\Controllers\ComissaoController::class, 'funcionario'])->name('comissoes.funcionario');
    
    // Produtos (alias para pdv/produtos - compatibilidade com legado)
    Route::get('/produtos', [\App\Http\Controllers\Pdv\ProdutoController::class, 'index'])->name('produtos.index');
    
    // Histórico
    Route::get('/historico', [FinanceiroController::class, 'historico'])->name('historico.index');
    
    // Relatórios WhatsApp
    Route::get('/relatorio_whatsapp', [\App\Http\Controllers\RelatorioWhatsAppController::class, 'index'])->name('relatorios.whatsapp');
    
    // Pagamentos
    Route::post('/api/gerar_pagamento', [\App\Http\Controllers\PaymentController::class, 'gerarPagamento'])->name('payment.gerar');
    Route::post('/api/consultar_status', [\App\Http\Controllers\PaymentController::class, 'consultarStatus'])->name('payment.consultar-status');
    
    // Campanhas/Agendar Disparo (placeholder - ainda não implementado)
    Route::get('/agendar_disparo', function () {
        return view('marketing.agendar-disparo');
    })->name('agendar-disparo.index');
    
    // PDV - Ponto de Venda
    Route::prefix('pdv')->name('pdv.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Pdv\PdvController::class, 'index'])->name('index');
        
        // Caixa
        Route::prefix('caixa')->name('caixa.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Pdv\CaixaController::class, 'index'])->name('index');
            Route::post('/abrir', [\App\Http\Controllers\Pdv\CaixaController::class, 'abrir'])->name('abrir');
            Route::post('/{caixa}/fechar', [\App\Http\Controllers\Pdv\CaixaController::class, 'fechar'])->name('fechar');
            Route::get('/status', [\App\Http\Controllers\Pdv\CaixaController::class, 'status'])->name('status');
        });
        
        // Produtos
        Route::resource('produtos', \App\Http\Controllers\Pdv\ProdutoController::class);
        Route::get('/produtos/buscar/codigo', [\App\Http\Controllers\Pdv\ProdutoController::class, 'buscarPorCodigo'])->name('produtos.buscar-codigo');
        
        // Estoque
        Route::get('/estoque', [\App\Http\Controllers\Pdv\EstoqueController::class, 'index'])->name('estoque.index');
        Route::post('/estoque/{produto}/adicionar', [\App\Http\Controllers\Pdv\EstoqueController::class, 'adicionar'])->name('estoque.adicionar');
        Route::post('/estoque/{produto}/remover', [\App\Http\Controllers\Pdv\EstoqueController::class, 'remover'])->name('estoque.remover');
        Route::post('/estoque/{produto}/ajustar', [\App\Http\Controllers\Pdv\EstoqueController::class, 'ajustar'])->name('estoque.ajustar');
        Route::get('/estoque/baixo', [\App\Http\Controllers\Pdv\EstoqueController::class, 'estoqueBaixo'])->name('estoque.baixo');
        
        // Vendas
        Route::get('/vendas', [\App\Http\Controllers\Pdv\VendaController::class, 'index'])->name('vendas.index');
        Route::get('/vendas/create', [\App\Http\Controllers\Pdv\VendaController::class, 'create'])->name('vendas.create');
        Route::post('/vendas', [\App\Http\Controllers\Pdv\VendaController::class, 'store'])->name('vendas.store');
        Route::get('/vendas/{venda}', [\App\Http\Controllers\Pdv\VendaController::class, 'show'])->name('vendas.show');
        Route::post('/vendas/{venda}/cancelar', [\App\Http\Controllers\Pdv\VendaController::class, 'cancelar'])->name('vendas.cancelar');
        Route::get('/vendas/buscar/clientes', [\App\Http\Controllers\Pdv\VendaController::class, 'buscarClientes'])->name('vendas.buscar-clientes');
        Route::get('/vendas/buscar/produtos', [\App\Http\Controllers\Pdv\VendaController::class, 'buscarProdutos'])->name('vendas.buscar-produtos');
        
        // Formas de Pagamento
        Route::get('/formas-pagamento', [\App\Http\Controllers\Pdv\FormaPagamentoController::class, 'index'])->name('formas-pagamento.index');
        Route::post('/formas-pagamento', [\App\Http\Controllers\Pdv\FormaPagamentoController::class, 'store'])->name('formas-pagamento.store');
        Route::put('/formas-pagamento/{formaPagamento}', [\App\Http\Controllers\Pdv\FormaPagamentoController::class, 'update'])->name('formas-pagamento.update');
        Route::delete('/formas-pagamento/{formaPagamento}', [\App\Http\Controllers\Pdv\FormaPagamentoController::class, 'destroy'])->name('formas-pagamento.destroy');
    });
});
