@extends('layouts.app')

@section('title', 'WhatsApp')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div align="right" class="mg-b-10">
            <a href="{{ route('dashboard') }}" class="btn btn-purple btn-sm">
                <i class="fa fa-arrow-left mg-r-5"></i> VOLTAR
            </a>
        </div>

        @if(session('sucesso'))
        <div class="alert alert-solid alert-success" role="alert">
            <strong>Sucesso!</strong> {{ session('sucesso') }}
        </div>
        <meta http-equiv="refresh" content="1;URL={{ route('whatsapp.index') }}" />
        @endif

        @if(session('erro'))
        <div class="alert alert-solid alert-danger" role="alert">
            <strong>Erro!</strong> {{ session('erro') }}
        </div>
        <meta http-equiv="refresh" content="2;URL={{ route('whatsapp.index') }}" />
        @endif

        @if(!$conectado)
        {{-- WhatsApp Desconectado --}}
        <div class="row">
            <div class="col-md-12">
                <div class="card card-info">
                    <div class="card-body" align="justify">
                        <label class="section-title">
                            <i class="fa fa-whatsapp" aria-hidden="true"></i> CONFIGURAÇÃO DO WHATSAPP
                        </label>
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <center>
                                        <i class="fa fa-times-circle-o tx-danger" style="font-size: 5em;" aria-hidden="true"></i>
                                        <br/>
                                        <h4 class="mg-t-10">Desconectado do WhatsApp</h4>
                                    </center>
                                </div>
                            </div>
                        </div>
                        
                        @if(session('qrcode'))
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <center>
                                        <p class="mg-b-10">Escaneie o QR Code com seu WhatsApp:</p>
                                        <img src="data:image/png;base64,{{ session('qrcode') }}" 
                                            alt="QR Code WhatsApp" 
                                            style="max-width: 300px; border: 2px solid #ddd; padding: 10px;">
                                        <p class="mg-t-10 tx-danger">
                                            <small>⚠️ O QR Code expira em alguns minutos. Se não funcionar, clique em "Conectar" novamente.</small>
                                        </p>
                                    </center>
                                </div>
                            </div>
                        </div>
                        @endif
                        
                        <hr />
                        
                        <form action="{{ route('whatsapp.connect') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-12">
                                    <div align="center">
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="fa fa-qrcode mg-r-5"></i> 
                                            {{ session('qrcode') ? 'Gerar Novo QR Code' : 'Conectar' }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        @else
        {{-- WhatsApp Conectado --}}
        <div class="row">
            <div class="col-md-12">
                <div class="card card-info">
                    <div class="card-body" align="justify">
                        <label class="section-title">
                            <i class="fa fa-whatsapp" aria-hidden="true"></i> WHATSAPP
                        </label>
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <center>
                                        <i class="fa fa-signal tx-success" style="font-size: 5em;" aria-hidden="true"></i>
                                        <br/>
                                        <h4 class="mg-t-10 tx-success">✅ Conectado ao WhatsApp</h4>
                                        <p class="tx-gray-600">Seu sistema está pronto para enviar mensagens automáticas!</p>
                                    </center>
                                </div>
                            </div>
                        </div>
                        
                        <hr />
                        
                        <form action="{{ route('whatsapp.disconnect') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-12">
                                    <div align="center">
                                        <button type="submit" class="btn btn-danger btn-lg" 
                                            onclick="return confirm('Tem certeza que deseja desconectar o WhatsApp?')">
                                            <i class="fa fa-sign-out mg-r-5"></i> Desconectar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
// Verifica status a cada 5 segundos se estiver tentando conectar
@if(session('qrcode'))
setInterval(function() {
    $.ajax({
        url: '{{ route("whatsapp.status") }}',
        type: 'GET',
        success: function(response) {
            if (response.connected) {
                window.location.reload();
            }
        }
    });
}, 5000);
@endif
</script>
@endpush
