@extends('layouts.app')

@section('title', 'Atualizações')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-history" aria-hidden="true"></i> Changelog - Histórico de Atualizações
            </label>
            <hr>

            <div class="timeline">
                <!-- Versão 1.1.0 -->
                <div class="timeline-item">
                    <div class="timeline-badge bg-success"><i class="fa fa-check"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h4 class="timeline-title">Versão 1.1.0 - Laravel Migration</h4>
                            <p><small class="text-muted"><i class="fa fa-calendar"></i> 05/12/2024</small></p>
                        </div>
                        <div class="timeline-body">
                            <p><strong>Migração completa para Laravel 11:</strong></p>
                            <ul>
                                <li>Sistema totalmente migrado para Laravel 11</li>
                                <li>Nova estrutura MVC</li>
                                <li>Banco de dados otimizado</li>
                                <li>Interface modernizada</li>
                                <li>Melhoria de performance</li>
                                <li>Segurança aprimorada</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Versão 1.0.5 -->
                <div class="timeline-item">
                    <div class="timeline-badge bg-info"><i class="fa fa-info"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h4 class="timeline-title">Versão 1.0.5</h4>
                            <p><small class="text-muted"><i class="fa fa-calendar"></i> 01/11/2024</small></p>
                        </div>
                        <div class="timeline-body">
                            <p><strong>Melhorias e correções:</strong></p>
                            <ul>
                                <li>Correção de bugs no sistema de mensagens</li>
                                <li>Melhorias no dark mode</li>
                                <li>Otimização de queries do banco de dados</li>
                                <li>Atualização de bibliotecas</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Versão 1.0.0 -->
                <div class="timeline-item">
                    <div class="timeline-badge bg-primary"><i class="fa fa-rocket"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h4 class="timeline-title">Versão 1.0.0 - Lançamento</h4>
                            <p><small class="text-muted"><i class="fa fa-calendar"></i> 01/01/2024</small></p>
                        </div>
                        <div class="timeline-body">
                            <p><strong>Primeira versão do sistema:</strong></p>
                            <ul>
                                <li>Gestão de clientes</li>
                                <li>Controle financeiro</li>
                                <li>Sistema de mensagens</li>
                                <li>Integrações de pagamento</li>
                                <li>WhatsApp</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card card-info mg-t-20">
                <div class="card-header">Informações do Sistema</div>
                <div class="card-body">
                    <p><strong>Versão Atual:</strong> 1.1.0</p>
                    <p><strong>Laravel:</strong> 11.x</p>
                    <p><strong>PHP:</strong> {{ PHP_VERSION }}</p>
                    <p><strong>Última Atualização:</strong> {{ now()->format('d/m/Y H:i') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.timeline {
    position: relative;
    padding: 20px 0;
}

.timeline-item {
    position: relative;
    padding-left: 60px;
    margin-bottom: 30px;
}

.timeline-badge {
    position: absolute;
    left: 0;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.timeline-panel {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 20px;
}

.timeline-title {
    margin: 0;
    font-size: 18px;
}

.timeline-body ul {
    margin-top: 10px;
}
</style>
@endpush
@endsection

