@extends('layouts.app')

@section('title', 'Tutoriais')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-book" aria-hidden="true"></i> Tutoriais e Ajuda
            </label>
            <hr>

            <div class="row">
                <div class="col-lg-4">
                    <div class="card card-info">
                        <div class="card-header">Primeiros Passos</div>
                        <div class="card-body">
                            <ul class="list-unstyled">
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Como configurar o sistema</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Cadastrando clientes</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Criando cobranças</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Gerenciando categorias</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card card-info">
                        <div class="card-header">Financeiro</div>
                        <div class="card-body">
                            <ul class="list-unstyled">
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Contas a receber</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Contas a pagar</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Dando baixa em parcelas</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Visualizando extrato</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card card-info">
                        <div class="card-header">WhatsApp e Integrações</div>
                        <div class="card-body">
                            <ul class="list-unstyled">
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Conectando WhatsApp</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Mensagens automáticas</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Configurando Mercado Pago</a>
                                </li>
                                <li class="mg-b-10">
                                    <a href="#"><i class="fa fa-play-circle mg-r-5"></i> Configurando Asaas</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mg-t-20">
                <div class="col-lg-12">
                    <div class="card card-info">
                        <div class="card-header">Perguntas Frequentes (FAQ)</div>
                        <div class="card-body">
                            <div class="accordion" id="accordionFAQ">
                                <div class="card">
                                    <div class="card-header" id="heading1">
                                        <h5 class="mb-0">
                                            <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapse1">
                                                Como recuperar minha senha?
                                            </button>
                                        </h5>
                                    </div>
                                    <div id="collapse1" class="collapse" data-parent="#accordionFAQ">
                                        <div class="card-body">
                                            Na tela de login, clique em "Recuperar Senha" e siga as instruções.
                                        </div>
                                    </div>
                                </div>

                                <div class="card">
                                    <div class="card-header" id="heading2">
                                        <h5 class="mb-0">
                                            <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapse2">
                                                Como adicionar um novo cliente?
                                            </button>
                                        </h5>
                                    </div>
                                    <div id="collapse2" class="collapse" data-parent="#accordionFAQ">
                                        <div class="card-body">
                                            Vá em Clientes > Novo Cliente e preencha os dados necessários.
                                        </div>
                                    </div>
                                </div>

                                <div class="card">
                                    <div class="card-header" id="heading3">
                                        <h5 class="mb-0">
                                            <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapse3">
                                                Como configurar as formas de pagamento?
                                            </button>
                                        </h5>
                                    </div>
                                    <div id="collapse3" class="collapse" data-parent="#accordionFAQ">
                                        <div class="card-body">
                                            Acesse Configurações e preencha as credenciais das APIs de pagamento (Mercado Pago, Asaas, etc).
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

