@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Detalhes da Venda #{{ $venda->id }}</h4>
                    <div>
                        @if($venda->status === 'ativa')
                            <form action="{{ route('pdv.vendas.cancelar', $venda->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Tem certeza que deseja cancelar esta venda?');">
                                @csrf
                                <button type="submit" class="btn btn-danger">
                                    <i class="fas fa-times"></i> Cancelar Venda
                                </button>
                            </form>
                        @endif
                        <a href="{{ route('pdv.vendas.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Voltar
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>Informações da Venda</h5>
                            <table class="table table-bordered">
                                <tr>
                                    <th width="40%">Data da Venda:</th>
                                    <td>{{ $venda->data_venda->format('d/m/Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>Cliente:</th>
                                    <td>{{ $venda->cliente->nome ?? 'Cliente não informado' }}</td>
                                </tr>
                                <tr>
                                    <th>Forma de Pagamento:</th>
                                    <td>{{ $venda->forma_pagamento }}</td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        @if($venda->status === 'ativa')
                                            <span class="badge bg-success">Ativa</span>
                                        @elseif($venda->status === 'cancelada')
                                            <span class="badge bg-danger">Cancelada</span>
                                        @else
                                            <span class="badge bg-warning">Trocada</span>
                                        @endif
                                    </td>
                                </tr>
                                @if($venda->funcionario)
                                <tr>
                                    <th>Funcionário:</th>
                                    <td>{{ $venda->funcionario->nome }}</td>
                                </tr>
                                <tr>
                                    <th>Comissão:</th>
                                    <td>R$ {{ number_format($venda->comissao, 2, ',', '.') }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5>Resumo Financeiro</h5>
                            <table class="table table-bordered">
                                <tr>
                                    <th width="40%">Subtotal:</th>
                                    <td class="text-end">R$ {{ number_format($venda->total + $venda->desconto, 2, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <th>Desconto:</th>
                                    <td class="text-end">R$ {{ number_format($venda->desconto, 2, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <th><strong>Total:</strong></th>
                                    <td class="text-end"><strong style="font-size: 1.2rem; color: #198754;">R$ {{ number_format($venda->total, 2, ',', '.') }}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <h5>Itens da Venda</h5>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th class="text-center">Quantidade</th>
                                    <th class="text-end">Preço Unitário</th>
                                    <th class="text-end">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($venda->itens as $item)
                                    <tr>
                                        <td>{{ $item->produto->nome }}</td>
                                        <td class="text-center">{{ $item->quantidade }}</td>
                                        <td class="text-end">R$ {{ number_format($item->preco_unitario, 2, ',', '.') }}</td>
                                        <td class="text-end">R$ {{ number_format($item->subtotal, 2, ',', '.') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

