@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Cards de Estatísticas -->
            <div class="row mb-3">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <h6>Total de Produtos</h6>
                            <h3>{{ $totalProdutos }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <h6>Total em Estoque</h6>
                            <h3>{{ number_format($totalEstoque, 0, ',', '.') }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <h6>Produtos com Estoque Baixo</h6>
                            <h3>{{ $produtosBaixo }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <h6>Valor Total em Estoque</h6>
                            <h3>R$ {{ number_format($valorTotal, 2, ',', '.') }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Controle de Estoque</h4>
                    <a href="{{ route('pdv.produtos.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Voltar aos Produtos
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    <!-- Filtros -->
                    <form method="GET" action="{{ route('pdv.estoque.index') }}" class="mb-3">
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" name="busca" class="form-control" placeholder="Buscar por nome ou código de barras" value="{{ request('busca') }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-check-label">
                                    <input type="checkbox" name="estoque_baixo" value="1" {{ request('estoque_baixo') ? 'checked' : '' }} class="form-check-input">
                                    Apenas estoque baixo
                                </label>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-secondary">Filtrar</button>
                                <a href="{{ route('pdv.estoque.index') }}" class="btn btn-outline-secondary">Limpar</a>
                            </div>
                        </div>
                    </form>

                    @if($produtos->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Produto</th>
                                        <th>Código</th>
                                        <th>Estoque Atual</th>
                                        <th>Estoque Mínimo</th>
                                        <th>Preço Venda</th>
                                        <th>Valor em Estoque</th>
                                        <th>Status</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($produtos as $produto)
                                        <tr class="{{ $produto->isEstoqueBaixo() ? 'table-warning' : '' }}">
                                            <td>{{ $produto->nome }}</td>
                                            <td>{{ $produto->codigo_barras ?? '-' }}</td>
                                            <td>
                                                <span class="{{ $produto->isEstoqueBaixo() ? 'text-danger fw-bold' : '' }}">
                                                    {{ $produto->estoque }}
                                                </span>
                                            </td>
                                            <td>{{ $produto->estoque_minimo }}</td>
                                            <td>R$ {{ number_format($produto->preco_venda, 2, ',', '.') }}</td>
                                            <td>R$ {{ number_format($produto->estoque * $produto->preco_venda, 2, ',', '.') }}</td>
                                            <td>
                                                @if($produto->isEstoqueBaixo())
                                                    <span class="badge bg-warning">
                                                        <i class="fas fa-exclamation-triangle"></i> Estoque Baixo
                                                    </span>
                                                @else
                                                    <span class="badge bg-success">OK</span>
                                                @endif
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#modalAdicionar{{ $produto->id }}">
                                                    <i class="fas fa-plus"></i> Adicionar
                                                </button>
                                                <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#modalRemover{{ $produto->id }}">
                                                    <i class="fas fa-minus"></i> Remover
                                                </button>
                                                <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#modalAjustar{{ $produto->id }}">
                                                    <i class="fas fa-edit"></i> Ajustar
                                                </button>
                                            </td>
                                        </tr>

                                        <!-- Modal Adicionar -->
                                        <div class="modal fade" id="modalAdicionar{{ $produto->id }}" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('pdv.estoque.adicionar', $produto->id) }}" method="POST">
                                                        @csrf
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Adicionar Estoque - {{ $produto->nome }}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="mb-3">
                                                                <label for="quantidade" class="form-label">Quantidade</label>
                                                                <input type="number" class="form-control" name="quantidade" min="1" required>
                                                            </div>
                                                            <p><strong>Estoque atual:</strong> {{ $produto->estoque }}</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                            <button type="submit" class="btn btn-success">Adicionar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal Remover -->
                                        <div class="modal fade" id="modalRemover{{ $produto->id }}" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('pdv.estoque.remover', $produto->id) }}" method="POST">
                                                        @csrf
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Remover Estoque - {{ $produto->nome }}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="mb-3">
                                                                <label for="quantidade" class="form-label">Quantidade</label>
                                                                <input type="number" class="form-control" name="quantidade" min="1" max="{{ $produto->estoque }}" required>
                                                            </div>
                                                            <p><strong>Estoque atual:</strong> {{ $produto->estoque }}</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                            <button type="submit" class="btn btn-warning">Remover</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal Ajustar -->
                                        <div class="modal fade" id="modalAjustar{{ $produto->id }}" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('pdv.estoque.ajustar', $produto->id) }}" method="POST">
                                                        @csrf
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Ajustar Estoque - {{ $produto->nome }}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="mb-3">
                                                                <label for="estoque" class="form-label">Novo Estoque</label>
                                                                <input type="number" class="form-control" name="estoque" min="0" value="{{ $produto->estoque }}" required>
                                                            </div>
                                                            <p><strong>Estoque atual:</strong> {{ $produto->estoque }}</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                            <button type="submit" class="btn btn-info">Ajustar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $produtos->links() }}
                        </div>
                    @else
                        <div class="alert alert-info">
                            Nenhum produto encontrado.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

