@extends('layouts.app')

@section('title', 'Mensagens')

@push('styles')
<style>
    /* Container de fundo para o breadcrumb */
    .d-flex.flex-wrap.align-items-center.justify-content-between.gap-3.mb-24 ul.d-flex.align-items-center.gap-2 {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 12px;
        padding: 12px 20px;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
    }

    /* Estilos para variáveis organizadas */
    .variables-container {
        border: 1px solid var(--bs-border-color);
        border-radius: 8px;
        padding: 15px;
        background: var(--bs-body-bg);
    }

    .variable-section {
        border-bottom: 1px solid var(--bs-border-color);
        padding-bottom: 10px;
    }

    .variable-section:last-child {
        border-bottom: none;
        padding-bottom: 0;
    }

    .variable-section h6 {
        margin-bottom: 8px !important;
        font-weight: 600 !important;
    }

    .optional {
        transition: all 0.2s ease;
        cursor: pointer;
        border-radius: 4px !important;
        padding: 4px 8px !important;
        font-weight: 500 !important;
        background-color: var(--bs-secondary-bg) !important;
        color: var(--bs-body-color) !important;
        border: 1px solid var(--bs-border-color) !important;
        text-decoration: none !important;
    }

    .optional:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        background-color: var(--bs-primary) !important;
        color: white !important;
        text-decoration: none !important;
    }

    /* Scrollbar personalizada */
    .variables-container::-webkit-scrollbar {
        width: 6px;
    }

    .variables-container::-webkit-scrollbar-track {
        background: var(--bs-border-color);
        border-radius: 3px;
    }

    .variables-container::-webkit-scrollbar-thumb {
        background: var(--bs-primary);
        border-radius: 3px;
    }

    .variables-container::-webkit-scrollbar-thumb:hover {
        background: var(--bs-primary-dark);
    }
</style>
@endpush

@section('content')
<div class="dashboard-main-body">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
        <h6 class="fw-semibold mb-0">Mensagens</h6>
        <ul class="d-flex align-items-center gap-2">
            <li class="fw-medium">
                <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
                    <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                    Dashboard
                </a>
            </li>
            <li>-</li>
            <li class="fw-medium">Mensagens</li>
        </ul>
    </div>

    <div class="card basic-data-table">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">Mensagens</h5>
            <div>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createMessageModal">
                    <iconify-icon icon="mingcute:add-line"></iconify-icon>
                </button>
                <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#dicasModal">
                    <iconify-icon icon="mingcute:bulb-line"></iconify-icon>
                </button>
            </div>
        </div>
        <div class="card-body table-responsive">
            <table class="table bordered-table mb-0 w-100" id="dataTable" data-page-length='10'>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Tipo</th>
                        <th>Dias</th>
                        <th>Hora</th>
                        <th>Envio Automático</th>
                        <th>Mensagem</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($mensagens as $mensagem)
                        @php
                            $tipomsg = '';
                            if ($mensagem->tipo == '1') {
                                $tipomsg = "A vencer";
                            } elseif ($mensagem->tipo == '3') {
                                $tipomsg = "Cobrança no dia";
                            } elseif ($mensagem->tipo == '4') {
                                $tipomsg = "Cobrança mensalidade vencida";
                            } elseif ($mensagem->tipo == '5') {
                                $tipomsg = "Comprovante";
                            } elseif ($mensagem->tipo == '6') {
                                $tipomsg = "Cobrança Manual";
                            } elseif ($mensagem->tipo == '10') {
                                $tipomsg = "Comprovante PDV";
                            }
                        @endphp
                        <tr>
                            <td>{{ $mensagem->id }}</td>
                            <td>{{ $tipomsg }}</td>
                            <td>{{ $mensagem->dias }}</td>
                            <td>{{ $mensagem->hora }}</td>
                            <td>
                                @if ($mensagem->status == '1')
                                    <button class="btn btn-success btn-sm">Ativo</button>
                                @else
                                    <button class="btn btn-danger btn-sm">Desativado</button>
                                @endif
                            </td>
                            <td>{{ Str::limit($mensagem->msg, 50) }}...</td>
                            <td align="center">
                                <button type="button"
                                    class="w-32-px h-32-px bg-warning-focus text-warning-main rounded-circle d-inline-flex align-items-center justify-content-center border-0"
                                    data-bs-toggle="modal" data-bs-target="#editModal{{ $mensagem->id }}"
                                    data-toggle="tooltip" data-placement="top" title="Editar Mensagem">
                                    <iconify-icon icon="mingcute:edit-2-line"></iconify-icon>
                                </button>
                                <button type="button"
                                    class="w-32-px h-32-px bg-danger-focus text-danger-main rounded-circle d-inline-flex align-items-center justify-content-center border-0"
                                    data-bs-toggle="modal" data-bs-target="#deleteModal{{ $mensagem->id }}"
                                    data-toggle="tooltip" data-placement="top" title="Deletar Mensagem">
                                    <iconify-icon icon="mingcute:delete-2-line"></iconify-icon>
                                </button>
                                @if ($mensagem->status == '1')
                                    <form action="{{ route('mensagens.update', $mensagem->id) }}" method="post" style="display:inline;">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="status" value="0">
                                        <button type="submit" class="w-32-px h-32-px bg-danger-focus text-danger-main rounded-circle d-inline-flex align-items-center justify-content-center border-0" data-toggle="tooltip" data-placement="top" title="Desativar Mensagem">
                                            <i class="fa fa-times"></i>
                                        </button>
                                    </form>
                                @elseif ($mensagem->status == '0')
                                    <form action="{{ route('mensagens.update', $mensagem->id) }}" method="post" style="display:inline;">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="status" value="1">
                                        <button type="submit" class="w-32-px h-32-px bg-info-focus text-info-main rounded-circle d-inline-flex align-items-center justify-content-center border-0" data-toggle="tooltip" data-placement="top" title="Ativar Mensagem">
                                            <i class="fa fa-thumbs-up"></i>
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                        <!-- Edit Modal -->
                        <div class="modal fade" id="editModal{{ $mensagem->id }}" tabindex="-1"
                            aria-labelledby="editModalLabel{{ $mensagem->id }}" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="editModalLabel{{ $mensagem->id }}">Editar</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <form action="{{ route('mensagens.update', $mensagem->id) }}" method="post">
                                            @csrf
                                            @method('PUT')
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Dias:</label>
                                                        <input id="dias" type="number" name="dias" min="1"
                                                            class="form-control"
                                                            value="{{ $mensagem->dias }}"
                                                            required
                                                            oninvalid="this.setCustomValidity('Por favor, digite um número maior ou igual a 1.')"
                                                            oninput="this.setCustomValidity('')">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Hora de execução:</label>
                                                        <input id="hora" type="time" name="hora" class="form-control"
                                                            value="{{ date('H:i', strtotime($mensagem->hora)) }}"
                                                            required
                                                            oninvalid="this.setCustomValidity('Por favor, selecione um horário.')"
                                                            oninput="this.setCustomValidity('')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>Mensagem:</label>
                                                        <textarea name="msg" cols="30" rows="7"
                                                            class="form-control"
                                                            required
                                                            oninvalid="this.setCustomValidity('Por favor, digite uma mensagem.')"
                                                            oninput="this.setCustomValidity('')">{{ $mensagem->msg }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="fw-semibold mb-3">📝 Variáveis Disponíveis:</label>
                                                        <div class="variables-container" style="max-height: 300px; overflow-y: auto;">
                                                            
                                                            <!-- Cliente -->
                                                            <div class="variable-section mb-3">
                                                                <h6 class="text-primary fw-semibold mb-2" style="font-size: 0.85rem;">
                                                                    <i class="fa fa-user me-1"></i>Dados do Cliente
                                                                </h6>
                                                                <div class="d-flex flex-wrap gap-1 mb-2">
                                                                    <a href="#" class="optional badge" data-value="#NOME#" style="font-size: 0.75rem;">#NOME#</a>
                                                                    <a href="#" class="optional badge" data-value="#EMPRESA#" style="font-size: 0.75rem;">#EMPRESA#</a>
                                                                    <a href="#" class="optional badge" data-value="#CNPJ#" style="font-size: 0.75rem;">#CNPJ#</a>
                                                                    <a href="#" class="optional badge" data-value="#ENDERECO#" style="font-size: 0.75rem;">#ENDERECO#</a>
                                                                    <a href="#" class="optional badge" data-value="#CONTATO#" style="font-size: 0.75rem;">#CONTATO#</a>
                                                                </div>
                                                            </div>

                                                            <!-- Pagamento -->
                                                            <div class="variable-section mb-3">
                                                                <h6 class="text-success fw-semibold mb-2" style="font-size: 0.85rem;">
                                                                    <i class="fa fa-money me-1"></i>Pagamento
                                                                </h6>
                                                                <div class="d-flex flex-wrap gap-1 mb-2">
                                                                    <a href="#" class="optional badge" data-value="#VALOR#" style="font-size: 0.75rem;">#VALOR#</a>
                                                                    <a href="#" class="optional badge" data-value="#VENCIMENTO#" style="font-size: 0.75rem;">#VENCIMENTO#</a>
                                                                    <a href="#" class="optional badge" data-value="#DATAPAGAMENTO#" style="font-size: 0.75rem;">#DATAPAGAMENTO#</a>
                                                                    <a href="#" class="optional badge" data-value="#TYPE#" style="font-size: 0.75rem;">#TYPE#</a>
                                                                </div>
                                                            </div>

                                                            <!-- Produto -->
                                                            <div class="variable-section mb-3">
                                                                <h6 class="text-info fw-semibold mb-2" style="font-size: 0.85rem;">
                                                                    <i class="fa fa-box me-1"></i>Produto
                                                                </h6>
                                                                <div class="d-flex flex-wrap gap-1 mb-2">
                                                                    <a href="#" class="optional badge" data-value="#PRODUTO#" style="font-size: 0.75rem;">#PRODUTO#</a>
                                                                </div>
                                                            </div>

                                                            <!-- Parcelamento -->
                                                            <div class="variable-section mb-3">
                                                                <h6 class="text-warning fw-semibold mb-2" style="font-size: 0.85rem;">
                                                                    <i class="fa fa-credit-card me-1"></i>Parcelamento
                                                                </h6>
                                                                <div class="d-flex flex-wrap gap-1 mb-2">
                                                                    <a href="#" class="optional badge" data-value="#PARCELAS#" style="font-size: 0.75rem;">#PARCELAS#</a>
                                                                    <a href="#" class="optional badge" data-value="#CICLO#" style="font-size: 0.75rem;">#CICLO#</a>
                                                                    <a href="#" class="optional badge" data-value="#VALOR_PARCELA#" style="font-size: 0.75rem;">#VALOR_PARCELA#</a>
                                                                    <a href="#" class="optional badge" data-value="#PRIMEIRO_VENCIMENTO#" style="font-size: 0.75rem;">#PRIMEIRO_VENCIMENTO#</a>
                                                                    <a href="#" class="optional badge" data-value="#PROX_PARCELAS#" style="font-size: 0.75rem;">#PROX_PARCELAS#</a>
                                                                </div>
                                                            </div>

                                                        </div>
                                                        
                                                        <!-- Tooltip de ajuda -->
                                                        <div class="mt-2">
                                                            <small class="text-muted">
                                                                <i class="fa fa-info-circle me-1"></i>
                                                                Clique nas variáveis para inserir automaticamente na mensagem
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-primary" name="cart">Atualizar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Delete Modal -->
                        <div class="modal fade" id="deleteModal{{ $mensagem->id }}" tabindex="-1"
                            aria-labelledby="deleteModalLabel{{ $mensagem->id }}" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header bg-danger text-white">
                                        <h5 class="modal-title" id="deleteModalLabel{{ $mensagem->id }}">
                                            Deletar</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Tem certeza que deseja deletar esta mensagem?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <form action="{{ route('mensagens.destroy', $mensagem->id) }}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger">Deletar</button>
                                        </form>
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Cancelar</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Create Modal -->
<div class="modal fade" id="createMessageModal" tabindex="-1" aria-labelledby="createMessageModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createMessageModalLabel">Criar</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('mensagens.store') }}" method="post">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Tipo de Mensagem:</label>
                                <select name="tipo" class="form-control">
                                    <option value="1">A vencer</option>
                                    <option value="3">Cobrança no dia</option>
                                    <option value="4">Cobrança mensalidade vencida</option>
                                    <option value="5">Comprovante</option>
                                    <option value="6">Cobrança Manual</option>
                                    <option value="10">Comprovante PDV</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Dias:</label>
                                <input
                                    id="dias"
                                    type="number"
                                    name="dias"
                                    min="1"
                                    class="form-control"
                                    value="1"
                                    required
                                    oninvalid="this.setCustomValidity('Por favor, digite um número maior ou igual a 1.')"
                                    oninput="this.setCustomValidity('')"
                                >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Hora de execução:</label>
                                <input id="hora" type="time" name="hora" class="form-control" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Mensagem:</label>
                                <textarea name="msg" cols="30" rows="7" class="form-control" required></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="fw-semibold mb-3">📝 Variáveis Disponíveis:</label>
                                <div class="variables-container" style="max-height: 300px; overflow-y: auto;">
                                    
                                    <!-- Cliente -->
                                    <div class="variable-section mb-3">
                                        <h6 class="text-primary fw-semibold mb-2" style="font-size: 0.85rem;">
                                            <i class="fa fa-user me-1"></i>Dados do Cliente
                                        </h6>
                                        <div class="d-flex flex-wrap gap-1 mb-2">
                                            <a href="#" class="optional badge" data-value="#NOME#" style="font-size: 0.75rem;">#NOME#</a>
                                            <a href="#" class="optional badge" data-value="#EMPRESA#" style="font-size: 0.75rem;">#EMPRESA#</a>
                                            <a href="#" class="optional badge" data-value="#CNPJ#" style="font-size: 0.75rem;">#CNPJ#</a>
                                            <a href="#" class="optional badge" data-value="#ENDERECO#" style="font-size: 0.75rem;">#ENDERECO#</a>
                                            <a href="#" class="optional badge" data-value="#CONTATO#" style="font-size: 0.75rem;">#CONTATO#</a>
                                        </div>
                                    </div>

                                    <!-- Pagamento -->
                                    <div class="variable-section mb-3">
                                        <h6 class="text-success fw-semibold mb-2" style="font-size: 0.85rem;">
                                            <i class="fa fa-money me-1"></i>Pagamento
                                        </h6>
                                        <div class="d-flex flex-wrap gap-1 mb-2">
                                            <a href="#" class="optional badge" data-value="#VALOR#" style="font-size: 0.75rem;">#VALOR#</a>
                                            <a href="#" class="optional badge" data-value="#VENCIMENTO#" style="font-size: 0.75rem;">#VENCIMENTO#</a>
                                            <a href="#" class="optional badge" data-value="#DATAPAGAMENTO#" style="font-size: 0.75rem;">#DATAPAGAMENTO#</a>
                                            <a href="#" class="optional badge" data-value="#TYPE#" style="font-size: 0.75rem;">#TYPE#</a>
                                        </div>
                                    </div>

                                    <!-- Produto -->
                                    <div class="variable-section mb-3">
                                        <h6 class="text-info fw-semibold mb-2" style="font-size: 0.85rem;">
                                            <i class="fa fa-box me-1"></i>Produto
                                        </h6>
                                        <div class="d-flex flex-wrap gap-1 mb-2">
                                            <a href="#" class="optional badge" data-value="#PRODUTO#" style="font-size: 0.75rem;">#PRODUTO#</a>
                                        </div>
                                    </div>

                                    <!-- Parcelamento -->
                                    <div class="variable-section mb-3">
                                        <h6 class="text-warning fw-semibold mb-2" style="font-size: 0.85rem;">
                                            <i class="fa fa-credit-card me-1"></i>Parcelamento
                                        </h6>
                                        <div class="d-flex flex-wrap gap-1 mb-2">
                                            <a href="#" class="optional badge" data-value="#PARCELAS#" style="font-size: 0.75rem;">#PARCELAS#</a>
                                            <a href="#" class="optional badge" data-value="#CICLO#" style="font-size: 0.75rem;">#CICLO#</a>
                                            <a href="#" class="optional badge" data-value="#VALOR_PARCELA#" style="font-size: 0.75rem;">#VALOR_PARCELA#</a>
                                            <a href="#" class="optional badge" data-value="#PRIMEIRO_VENCIMENTO#" style="font-size: 0.75rem;">#PRIMEIRO_VENCIMENTO#</a>
                                            <a href="#" class="optional badge" data-value="#PROX_PARCELAS#" style="font-size: 0.75rem;">#PROX_PARCELAS#</a>
                                        </div>
                                    </div>

                                </div>
                                
                                <!-- Tooltip de ajuda -->
                                <div class="mt-2">
                                    <small class="text-muted">
                                        <i class="fa fa-info-circle me-1"></i>
                                        Clique nas variáveis para inserir automaticamente na mensagem
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="modal-footer">
                        <input type="hidden" name="cart" value="1">
                        <button type="submit" class="btn btn-primary">Criar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Dicas Úteis -->
<div class="modal fade" id="dicasModal" tabindex="-1" aria-labelledby="dicasModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-white">
                <h5 class="modal-title"><i class="fa fa-lightbulb-o"></i> Dicas Úteis</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <ul style="list-style-type: none; padding-left: 0;">
                    <li>📝 <strong>Editar ou Criar Novo Template:</strong> Vá para a seção de notificações e clique em "Editar" ou "Criar Novo Template".</li>
                    <li>📅 <strong>Configuração dos Dias:</strong> O campo "Dias" representa o número de dias antes ou depois do vencimento da cobrança.</li>
                    <li>⏳ <strong>Cobranças no Dia:</strong> Sempre defina este campo como "1". Nunca use "0", pois isso pode impedir o envio correto.</li>
                    <li>⏰ <strong>Hora de Execução:</strong> Escolha o horário em que o sistema enviará as notificações de cobrança.</li>
                    <li>✉️ <strong>Mensagem Personalizada:</strong> Você pode visualizar as variáveis disponíveis para personalizar sua mensagem.</li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Verificar se a tabela já foi inicializada e destruir antes de recriar
        if ($.fn.DataTable.isDataTable('#dataTable')) {
            $('#dataTable').DataTable().destroy();
        }
        
        // Aguardar um pouco para garantir que o DOM está totalmente carregado
        setTimeout(function() {
            let table = new DataTable("#dataTable", {
                responsive: true,
                order: [[0, 'asc']],
                pageLength: 10,
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Portuguese-Brasil.json'
                },
                columnDefs: [
                    { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
                ]
            });
        }, 100);
    
    document.querySelectorAll('.optional').forEach(function(element) {
        element.addEventListener('click', function(event) {
            event.preventDefault();
            var value = this.getAttribute('data-value');
            var textarea = this.closest('.modal-body').querySelector('textarea[name="msg"]');
            
            // Adicionar variável na posição do cursor
            var start = textarea.selectionStart;
            var end = textarea.selectionEnd;
            var text = textarea.value;
            
            textarea.value = text.substring(0, start) + value + text.substring(end);
            
            // Posicionar cursor após a variável inserida
            textarea.selectionStart = textarea.selectionEnd = start + value.length;
            textarea.focus();
            
            // Feedback visual
            element.style.transform = 'scale(0.95)';
            setTimeout(() => {
                element.style.transform = '';
            }, 150);
        });
    });
    
    // Atalhos de teclado para variáveis comuns
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey || event.metaKey) {
            var textarea = document.querySelector('textarea[name="msg"]:focus');
            if (!textarea) return;
            
            switch(event.key) {
                case 'n':
                    event.preventDefault();
                    insertVariable(textarea, '#NOME#');
                    break;
                case 'v':
                    event.preventDefault();
                    insertVariable(textarea, '#VALOR#');
                    break;
                case 'p':
                    event.preventDefault();
                    insertVariable(textarea, '#PRODUTO#');
                    break;
            }
        }
    });
    
    function insertVariable(textarea, variable) {
        var start = textarea.selectionStart;
        var end = textarea.selectionEnd;
        var text = textarea.value;
        
        textarea.value = text.substring(0, start) + variable + text.substring(end);
        textarea.selectionStart = textarea.selectionEnd = start + variable.length;
        textarea.focus();
    }
</script>
@endpush
