@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Detalhes do Funcionário: {{ $funcionario->nome }}</h4>
                    <div>
                        <a href="{{ route('comissoes.funcionario', $funcionario->id) }}" class="btn btn-info">
                            <i class="fas fa-chart-line"></i> Ver Comissões
                        </a>
                        <a href="{{ route('funcionarios.edit', $funcionario->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Editar
                        </a>
                        <a href="{{ route('funcionarios.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Voltar
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>Informações do Funcionário</h5>
                            <table class="table table-bordered">
                                <tr>
                                    <th width="40%">Nome:</th>
                                    <td>{{ $funcionario->nome }}</td>
                                </tr>
                                <tr>
                                    <th>Login:</th>
                                    <td>{{ $funcionario->login }}</td>
                                </tr>
                                <tr>
                                    <th>Celular:</th>
                                    <td>{{ $funcionario->celular ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Porcentagem de Comissão:</th>
                                    <td>{{ number_format($funcionario->porcentagem_vendas, 2, ',', '.') }}%</td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        @if($funcionario->status)
                                            <span class="badge bg-success">Ativo</span>
                                        @else
                                            <span class="badge bg-danger">Inativo</span>
                                        @endif
                                    </td>
                                </tr>
                                @if($funcionario->funcoes)
                                <tr>
                                    <th>Funções Habilitadas:</th>
                                    <td>
                                        @foreach($funcionario->funcoes_array as $funcao)
                                            <span class="badge bg-secondary">{{ $funcao }}</span>
                                        @endforeach
                                    </td>
                                </tr>
                                @endif
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5>Estatísticas de Vendas</h5>
                            <table class="table table-bordered">
                                <tr>
                                    <th width="40%">Total de Vendas:</th>
                                    <td class="text-end">{{ $totalVendas }}</td>
                                </tr>
                                <tr>
                                    <th>Total Faturado:</th>
                                    <td class="text-end">R$ {{ number_format($totalFaturado, 2, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <th>Total de Comissões:</th>
                                    <td class="text-end"><strong style="color: #198754;">R$ {{ number_format($totalComissao, 2, ',', '.') }}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <h5>Últimas Vendas</h5>
                    @if($vendas->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Data</th>
                                        <th>Cliente</th>
                                        <th>Total</th>
                                        <th>Comissão</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($vendas as $venda)
                                        <tr>
                                            <td>#{{ $venda->id }}</td>
                                            <td>{{ $venda->data_venda->format('d/m/Y H:i') }}</td>
                                            <td>{{ $venda->cliente->nome ?? 'Cliente não informado' }}</td>
                                            <td>R$ {{ number_format($venda->total, 2, ',', '.') }}</td>
                                            <td>R$ {{ number_format($venda->comissao, 2, ',', '.') }}</td>
                                            <td>
                                                <a href="{{ route('pdv.vendas.show', $venda->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            Nenhuma venda encontrada para este funcionário.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

