@extends('layouts.app')

@section('title', 'Contas a Pagar')

@push('styles')
<style>
/* Container de fundo para o breadcrumb */
.d-flex.flex-wrap.align-items-center.justify-content-between.gap-3.mb-24 ul.d-flex.align-items-center.gap-2 {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 12px 20px;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
}

@media (prefers-color-scheme: dark) {
  .dropdown-mes .dropdown-menu {
    background-color: #2c2f45 !important;
    color: #ffffff !important;
    border: 1px solid #444;
  }

  .dropdown-mes .dropdown-item {
    color: #ffffff !important;
  }

  .dropdown-mes .dropdown-item:hover,
  .dropdown-mes .dropdown-item:focus {
    background-color: #3a3f5c !important;
    color: #ffffff !important;
  }
}
</style>
@endpush

@section('content')
<div class="dashboard-main-body">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
        <h6 class="fw-semibold mb-0">Contas a Pagar</h6>
        <ul class="d-flex align-items-center gap-2">
            <li class="fw-medium">
                <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
                    <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                    Dashboard
                </a>
            </li>
            <li>-</li>
            <li class="fw-medium">Contas a Pagar</li>
        </ul>
    </div>
    
    <!-- Dashboard Cards -->
    <div class="row gy-4 mb-4">
        <!-- Total de Despesas do Mês -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body p-20">
                    <div class="d-flex align-items-center gap-2">
                        <span class="w-48-px h-48-px radius-8 d-flex justify-content-center align-items-center text-xl bg-primary-100 text-primary-600">
                            <iconify-icon icon="solar:wallet-money-outline"></iconify-icon>
                        </span>
                        <div>
                            <span class="text-secondary-light fw-medium text-sm d-block mb-4">💰 Total de Despesas</span>
                            <h6 class="fw-semibold mb-0">R$ {{ number_format($totalDespesas, 2, ',', '.') }}</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Despesas Pagas -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body p-20">
                    <div class="d-flex align-items-center gap-2">
                        <span class="w-48-px h-48-px radius-8 d-flex justify-content-center align-items-center text-xl bg-success-100 text-success-600">
                            <iconify-icon icon="solar:check-circle-outline"></iconify-icon>
                        </span>
                        <div>
                            <span class="text-secondary-light fw-medium text-sm d-block mb-4">✅ Despesas Pagas</span>
                            <h6 class="fw-semibold mb-0">R$ {{ number_format($despesasPagas, 2, ',', '.') }}</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Despesas Pendentes -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-body p-20">
                    <div class="d-flex align-items-center gap-2">
                        <span class="w-48-px h-48-px radius-8 d-flex justify-content-center align-items-center text-xl bg-warning-100 text-warning-600">
                            <iconify-icon icon="solar:clock-circle-outline"></iconify-icon>
                        </span>
                        <div>
                            <span class="text-secondary-light fw-medium text-sm d-block mb-4">⏳ Despesas Pendentes</span>
                            <h6 class="fw-semibold mb-0">R$ {{ number_format($despesasPendentes, 2, ',', '.') }}</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contas Vencidas -->
        <div class="col-md-6">
            <div class="card border-start-width-3-danger">
                <div class="card-body p-16">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <span class="text-secondary-light fw-medium text-sm d-block mb-4">🔴 Contas Vencidas</span>
                            <h6 class="fw-semibold mb-0">{{ $totalVencidas }} contas</h6>
                            <span class="text-danger-600 fw-semibold text-sm">R$ {{ number_format($valorVencido, 2, ',', '.') }}</span>
                        </div>
                        <span class="w-48-px h-48-px radius-8 d-flex justify-content-center align-items-center text-2xl bg-danger-100 text-danger-600">
                            <iconify-icon icon="solar:danger-circle-outline"></iconify-icon>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- A Vencer (7 dias) -->
        <div class="col-md-6">
            <div class="card border-start-width-3-warning">
                <div class="card-body p-16">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <span class="text-secondary-light fw-medium text-sm d-block mb-4">⏰ A Vencer (7 dias)</span>
                            <h6 class="fw-semibold mb-0">{{ $totalAVencer }} contas</h6>
                            <span class="text-warning-600 fw-semibold text-sm">R$ {{ number_format($valorAVencer, 2, ',', '.') }}</span>
                        </div>
                        <span class="w-48-px h-48-px radius-8 d-flex justify-content-center align-items-center text-2xl bg-warning-100 text-warning-600">
                            <iconify-icon icon="solar:clock-circle-outline"></iconify-icon>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráfico de Despesas por Categoria -->
    @if(count($categorias_labels ?? []) > 0)
    <div class="row gy-4 mt-24">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0 fw-semibold">📊 Despesas por Categoria ({{ date('m/Y', strtotime("$ano-$mes-01")) }})</h6>
                </div>
                <div class="card-body p-24 text-center">
                    <div id="graficoCateg" class="d-flex justify-content-center apexcharts-tooltip-z-none"></div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Container Principal -->
    <div class="card basic-data-table mt-4">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2">
            <!-- Botões Principais -->
            <div class="d-flex align-items-center gap-2 flex-wrap">
                <a href="{{ route('financeiro.criar-conta-pagar') }}" class="fw-semibold btn btn-success-600 radius-12 px-24 py-14 d-flex align-items-center justify-content-center gap-2">
                    <iconify-icon icon="tabler:plus" class="text-xl"></iconify-icon>
                    Nova Despesa
                </a>
            </div>

            <!-- Ações da Tabela -->
            <div class="d-flex align-items-center gap-2 flex-wrap">
                <!-- Seletor de Mês -->
                <div class="dropdown dropdown-mes">
                    <button class="btn btn-outline-primary-600 dropdown-toggle" data-bs-toggle="dropdown">
                        Mês: {{ $mes }}
                    </button>
                    <ul class="dropdown-menu">
                        @foreach($meses as $m => $nome)
                            <li><a class="dropdown-item" href="?mes={{ $m }}">{{ $nome }}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>

        <!-- Filtros -->
        <div class="card-body border-top pt-16 pb-0">
            <form method="GET" class="row gy-3 align-items-end">
                <input type="hidden" name="mes" value="{{ $mes }}">
                
                <div class="col-md-4 col-lg-3">
                    <label class="form-label fw-semibold text-primary-light text-sm mb-8">Buscar</label>
                    <div class="input-group">
                        <span class="input-group-text bg-base">
                            <iconify-icon icon="solar:magnifer-outline"></iconify-icon>
                        </span>
                        <input type="text" name="busca" value="{{ $busca }}" class="form-control radius-8 h-48-px" placeholder="Buscar por descrição ou categoria">
                    </div>
                </div>

                <div class="col-md-4 col-lg-3">
                    <label class="form-label fw-semibold text-primary-light text-sm mb-8">Filtrar por Categoria</label>
                    <select name="categoria" class="form-control radius-8 h-48-px form-select">
                        <option value="">Todas as Categorias</option>
                        @foreach($todasCategorias ?? [] as $cat)
                            <option value="{{ $cat->id }}" {{ $filtro_categoria == $cat->id ? 'selected' : '' }}>
                                {{ $cat->nome }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4 col-lg-3">
                    <label class="form-label fw-semibold text-primary-light text-sm mb-8">Filtrar por Status</label>
                    <select name="status" class="form-control radius-8 h-48-px form-select">
                        <option value="">Todos</option>
                        <option value="pago" {{ $filtro_status == 'pago' ? 'selected' : '' }}>Pago</option>
                        <option value="aberto" {{ $filtro_status == 'aberto' ? 'selected' : '' }}>Aberto</option>
                        <option value="vencido" {{ $filtro_status == 'vencido' ? 'selected' : '' }}>Vencido</option>
                    </select>
                </div>

                <div class="col-md-12 col-lg-3">
                    <button type="submit" class="btn btn-primary-600 radius-8 h-48-px w-100">
                        <iconify-icon icon="solar:magnifer-outline"></iconify-icon>
                        Filtrar
                    </button>
                </div>
            </form>
        </div>

        <!-- Tabela -->
        <div class="card-body">
            <div class="table-responsive">
                <table class="table bordered-table mb-0 w-100" id="datatable1" data-page-length='10'>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Descrição</th>
                            <th>Categoria</th>
                            <th>Valor</th>
                            <th>Vencimento</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($contas) && $contas->count() > 0)
                            @foreach($contas as $conta)
                            <tr>
                                <td>{{ $conta->id ?? '-' }}</td>
                                <td>{{ $conta->descricao ?? '-' }}</td>
                                <td>{{ $conta->categoria ?? '-' }}</td>
                                <td>R$ {{ number_format($conta->valor ?? 0, 2, ',', '.') }}</td>
                                <td>{{ $conta->datavencimento ?? '-' }}</td>
                                <td>
                                    @if(($conta->status ?? '0') == '1')
                                        <span class="bg-success-focus text-success-main px-24 py-4 rounded-pill fw-medium text-sm">Pago</span>
                                    @else
                                        <span class="bg-warning-focus text-warning-main px-24 py-4 rounded-pill fw-medium text-sm">Pendente</span>
                                    @endif
                                </td>
                                <td>
                                    @if(($conta->status ?? '0') == '0')
                                    <form action="{{ route('financeiro.baixar-conta-pagar', $conta->id) }}" method="POST" style="display: inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-success btn-sm" title="Baixar">
                                            <i class="fa fa-check"></i>
                                        </button>
                                    </form>
                                    @else
                                    <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">
                                    Nenhuma conta a pagar encontrada.
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Aguardar um pouco para garantir que o DOM está totalmente carregado
        setTimeout(function() {
            if ($.fn.DataTable.isDataTable('#datatable1')) {
                $('#datatable1').DataTable().destroy();
            }
            
            // Verificar se a tabela tem dados válidos (sem colspan)
            var table = $('#datatable1');
            var tbody = table.find('tbody');
            var rows = tbody.find('tr');
            var hasValidData = false;
            
            // Remover linha com colspan antes de inicializar DataTables
            rows.each(function() {
                var $row = $(this);
                var $td = $row.find('td[colspan]');
                if ($td.length > 0) {
                    $row.remove(); // Remove linha com colspan
                } else {
                    var tdCount = $row.find('td').length;
                    // Se a linha tem 7 colunas, tem dados válidos
                    if (tdCount === 7) {
                        hasValidData = true;
                    }
                }
            });
            
            // Só inicializar se houver dados válidos
            if (hasValidData) {
                $('#datatable1').DataTable({
                    responsive: true,
                    order: [[0, 'asc']],
                    pageLength: 10,
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Portuguese-Brasil.json'
                    },
                    columnDefs: [
                        { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
                    ],
                    autoWidth: false,
                    processing: false,
                    serverSide: false
                });
            }

        // Gráfico de categorias (se houver dados)
        @if(count($categorias_labels ?? []) > 0)
        var options = {
            series: @json($categorias_valores),
            chart: {
                type: 'donut',
                height: 350
            },
            labels: @json($categorias_labels),
            colors: @json($categorias_cores),
            legend: {
                position: 'bottom'
            },
            dataLabels: {
                enabled: true,
                formatter: function(val) {
                    return val.toFixed(1) + "%";
                }
            }
        };
        var chart = new ApexCharts(document.querySelector("#graficoCateg"), options);
        chart.render();
        @endif
        }, 100);
    });
</script>
@endpush
