@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
        
        {{-- Alerta de Nova Versão (apenas para admin) --}}
        @if(Auth::user()->tipo == 1 && isset($novaVersaoDisponivel) && $novaVersaoDisponivel)
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <strong><i class="fa fa-exclamation-triangle mg-r-5"></i> Nova Versão Disponível!</strong><br>
            Versão atual: <strong>{{ config('app.version') }}</strong> | 
            Nova versão: <strong>{{ $versaoRemota }}</strong><br>
            <a href="https://licencasgestor.plwstoremultishop.com/" target="_blank" class="btn btn-sm btn-primary mg-t-10">
                <i class="fa fa-download mg-r-5"></i> Baixar Atualização
            </a>
        </div>
        @endif
        
        {{-- Filtro de Mês --}}
        <div class="card border-0 radius-16 shadow-sm mb-3">
            <div class="card-body p-20 d-flex flex-wrap align-items-center justify-content-between gap-16">
                <div class="d-flex align-items-center gap-12">
                    <span class="badge bg-primary-100 text-primary-600 text-xs fw-semibold px-12 py-4 radius-pill d-inline-flex align-items-center gap-6">
                        <i class="fa fa-home"></i>
                        Painel financeiro
                    </span>
                    <div>
                        <h5 class="fw-semibold text-primary-light mb-4">Visão consolidada do gestor</h5>
                        <p class="text-secondary-light text-sm mb-0">Escolha o mês para atualizar indicadores e relatórios abaixo.</p>
                    </div>
                </div>
                <form method="get" class="d-flex flex-wrap align-items-center gap-16">
                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle rounded" type="button" id="dropdownMenuButton" data-toggle="dropdown">
                            <i class="icon ion-ios-calendar-outline tx-24"></i> {{ $mesParametro ? $meses[$mes] : 'Mês atual • ' . $meses[$mes] }}
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="{{ route('dashboard') }}">Mês Atual</a>
                            @foreach($meses as $num => $nome)
                            <a class="dropdown-item" href="{{ route('dashboard', ['mes' => $num]) }}">{{ $nome }}</a>
                            @endforeach
                        </div>
                    </div>
                    <span class="badge bg-success-100 text-success-600 text-xs fw-semibold px-12 py-4 radius-pill">
                        Hoje: {{ date('d/m/Y') }}
                    </span>
                </form>
            </div>
        </div>

        {{-- Card Promocional NFT e WhatsApp --}}
        <div class="row g-3 mb-3">
            <div class="col-xxl-8 col-lg-7">
                <div class="card border-0 radius-12 overflow-hidden position-relative h-100" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <div class="card-body p-32 d-flex align-items-center h-100">
                        <div class="flex-grow-1 text-white">
                            <h4 class="mb-16 text-white">Domine Cobranças e Campanhas no WhatsApp com o Gestor PRO</h4>
                            <p class="text-white text-md mb-0">Automatize cobranças, envie campanhas e controle o caixa do seu negócio em um só lugar. Com integração total ao WhatsApp, você economiza tempo, evita inadimplência e aumenta seus resultados.</p>
                            <div class="d-flex align-items-center flex-wrap mt-24 gap-16">
                                <a href="{{ route('financeiro.contas-receber') }}" class="btn rounded-pill border border-white text-white radius-8 px-32 py-11 hover-bg-white text-hover-dark">Criar Cobrança</a>
                                <a href="{{ route('tutoriais.index') }}" class="btn rounded-pill btn-light radius-8 px-28 py-11">Tutoriais</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-4 col-lg-5">
                <div class="card border-0 radius-18 shadow-sm h-100">
                    <div class="card-body p-24 d-flex flex-column gap-16">
                        <div class="d-flex justify-content-between align-items-start gap-12">
                            <div>
                                <span class="badge bg-success-100 text-success-600 text-xs fw-semibold px-12 py-4 radius-pill mb-8 d-inline-flex align-items-center gap-6">
                                    <i class="fa fa-whatsapp"></i>
                                    WhatsApp
                                </span>
                                <h5 class="fw-semibold text-neutral-900 mb-2">Conexões ativas</h5>
                                <p class="text-secondary-light text-sm mb-0">
                                    @if($whatsappConectado)
                                        API Conectada
                                    @else
                                        API Desconectada
                                    @endif
                                </p>
                            </div>
                            <a href="{{ route('whatsapp.index') }}" class="btn btn-sm btn-primary radius-pill px-16 py-6">
                                <i class="fa fa-cog"></i> Gerenciar
                            </a>
                        </div>
                        <div class="bg-base radius-14 px-16 py-12 border border-neutral-200 d-flex justify-content-between align-items-center">
                            <div>
                                <span class="fw-semibold text-neutral-900 d-block">Status da licença</span>
                                <small class="text-secondary-light d-block">
                                    @if($licencaDiasRestantes >= 0)
                                        Expira em: {{ $licencaDiasRestantes }} dias
                                    @else
                                        Expirada há {{ abs($licencaDiasRestantes) }} dias
                                    @endif
                                </small>
                                @if($licencaDataExpiracao)
                                <small class="text-secondary-light d-block">Data: {{ $licencaDataExpiracao }}</small>
                                @endif
                            </div>
                            <i class="fa fa-arrow-right text-secondary-light"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Cards Principais de Valores --}}
        <div class="row g-3 mb-3">
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-primary-100 text-primary-600">
                                <i class="fa fa-wallet text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">Recebidos no mês</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">R$ {{ number_format($valoresRecebidos, 2, ',', '.') }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('financeiro.contas-receber') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Ver detalhes <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-info-100 text-info-600">
                                <i class="fa fa-calendar text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">Recebidos hoje</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">R$ {{ number_format($valoresRecebidosHoje, 2, ',', '.') }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('financeiro.contas-receber') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Abrir relatórios <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-warning-100 text-warning-600">
                                <i class="fa fa-archive text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">A receber no mês</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">R$ {{ number_format($valoresAReceber, 2, ',', '.') }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('financeiro.contas-receber') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Cobrar clientes <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-danger-100 text-danger-600">
                                <i class="fa fa-file-invoice text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">Contas a pagar</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">R$ {{ number_format($valoresAPagar, 2, ',', '.') }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('financeiro.contas-pagar') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Organizar pagamentos <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        {{-- Cards de Estatísticas --}}
        <div class="row g-3 mb-3">
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-info-100 text-info-600">
                                <i class="fa fa-users text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">Clientes cadastrados</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">{{ $totalClientes }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('clientes.index') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Ver clientes <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-primary-100 text-primary-600">
                                <i class="fa fa-chart-line text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">Cobranças ativas</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">{{ $cobrancasAtivas }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('financeiro.contas-receber') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Gerenciar cobranças <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-danger-100 text-danger-600">
                                <i class="fa fa-exclamation-triangle text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">Mensalidades em aberto</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">{{ $parcelasAbertas }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('financeiro.contas-receber') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Cobrar clientes <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="card border-0 radius-16 shadow-sm h-100">
                    <div class="card-body p-20 d-flex flex-column gap-12">
                        <div class="d-flex align-items-center gap-12">
                            <span class="w-48-px h-48-px radius-12 d-inline-flex align-items-center justify-content-center bg-success-100 text-success-600">
                                <i class="fa fa-check-circle text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block">Mensalidades pagas</span>
                                <h6 class="fw-semibold text-neutral-900 mb-0">{{ $parcelasPagas }}</h6>
                            </div>
                        </div>
                        <a href="{{ route('financeiro.extrato') }}" class="text-primary-600 text-sm fw-semibold d-inline-flex align-items-center gap-2">
                            Ver histórico <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        {{-- Status do Caixa e Visão SaaS --}}
        <div class="row g-4 mb-3">
            <div class="col-xxl-4">
                <div class="d-flex flex-column gap-16 h-100">
                    {{-- Card Status do Caixa --}}
                    <div class="card border-0 radius-18 shadow-sm">
                        <div class="card-body p-24 d-flex align-items-start gap-16">
                            <span class="w-56-px h-56-px radius-16 d-inline-flex align-items-center justify-content-center bg-neutral-200 text-neutral-700">
                                <i class="fa fa-cash-register text-xl"></i>
                            </span>
                            <div>
                                <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block mb-6">Status do caixa</span>
                                @if($caixaStatus['aberto'])
                                    <h6 class="fw-semibold text-success-600 mb-1">Aberto</h6>
                                    <small class="text-secondary-light d-block">Por {{ $caixaStatus['atendente'] ?? 'N/A' }}</small>
                                    <small class="text-secondary-light">Desde {{ $caixaStatus['data_abertura'] ? \Carbon\Carbon::parse($caixaStatus['data_abertura'])->format('d/m/Y H:i') : 'N/A' }}</small>
                                @else
                                    <h6 class="fw-semibold text-danger-600 mb-1">Fechado</h6>
                                    <small class="text-secondary-light">Nenhum caixa em operação agora.</small>
                                @endif
                            </div>
                        </div>
                        <div class="card-footer bg-transparent border-0 pt-0 px-24 pb-24">
                            <a href="{{ route('pdv.index') }}" class="btn btn-sm btn-primary radius-pill px-18 py-8">
                                <i class="fa fa-arrow-right"></i> Acessar PDV
                            </a>
                        </div>
                    </div>

                    {{-- Card Visão SaaS (apenas superadmin) --}}
                    @if(Auth::user()->id == 1 && $dadosSaas)
                    <div class="card border-0 radius-18 shadow-sm">
                        <div class="card-body p-24">
                            <span class="text-xs text-neutral-600 fw-medium text-uppercase d-block mb-12">Visão SaaS</span>
                            <div class="d-flex flex-column gap-12">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-secondary-light">Usuários cadastrados</span>
                                    <span class="fw-semibold text-neutral-900">{{ $dadosSaas['total_usuarios'] }}</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-secondary-light">Usuários ativos</span>
                                    <span class="fw-semibold text-neutral-900">{{ $dadosSaas['usuarios_ativos'] }}</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-secondary-light">Planos cadastrados</span>
                                    <span class="fw-semibold text-neutral-900">{{ $dadosSaas['total_planos'] }}</span>
                                </div>
                            </div>
                            <a href="{{ route('usuarios.index') }}" class="btn btn-sm btn-outline-primary radius-pill px-18 py-8 mt-20">
                                <i class="fa fa-users"></i> Gerenciar usuários
                            </a>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            {{-- Gráfico de Estatística de Receita --}}
            <div class="col-xxl-8">
                <div class="card h-100">
                    <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                        <div>
                            <h6 class="mb-1 fw-bold text-lg">Estatística de Receita</h6>
                            <span class="text-secondary-light text-sm">Últimos 7 dias</span>
                        </div>
                        <div class="d-flex align-items-center gap-16 flex-wrap">
                            <span class="badge bg-success-100 text-success-600 text-xs fw-semibold px-12 py-4 radius-pill">
                                Recebido: R$ {{ number_format($receitaTotalRecebido, 2, ',', '.') }}
                            </span>
                            <span class="badge bg-warning-100 text-warning-600 text-xs fw-semibold px-12 py-4 radius-pill">
                                Previsto: R$ {{ number_format($receitaTotalPrevisto, 2, ',', '.') }}
                            </span>
                        </div>
                    </div>
                    <div class="card-body p-24">
                        <div id="revenueLineChart" style="min-height: 320px;"></div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Tabela de Últimos 10 Usuários (apenas superadmin) --}}
        @if(Auth::user()->id == 1 && $dadosSaas && $dadosSaas['ultimos_usuarios']->count() > 0)
        <div class="row mb-3">
            <div class="col-12">
                <div class="card h-100">
                    <div class="card-body p-24 mb-8">
                        <div class="d-flex align-items-center flex-wrap gap-2 justify-content-between mb-4">
                            <h6 class="mb-0 fw-bold text-lg">Últimos 10 Usuários Cadastrados</h6>
                            <a href="{{ route('usuarios.index') }}" class="btn btn-primary btn-sm">
                                <i class="fa fa-users"></i> Ver Todos
                            </a>
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table basic-table mb-0 w-100">
                                <thead>
                                    <tr>
                                        <th>S.L</th>
                                        <th>Nome</th>
                                        <th>Login</th>
                                        <th>Data de Cadastro</th>
                                        <th>Tipo</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($dadosSaas['ultimos_usuarios'] as $index => $usuario)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <span class="text-sm fw-medium">{{ $usuario->nome }}</span>
                                        </td>
                                        <td>
                                            <a href="#0" class="text-primary-600">{{ $usuario->login ?: 'N/A' }}</a>
                                        </td>
                                        <td>
                                            @if($usuario->created_at && \Carbon\Carbon::parse($usuario->created_at) <= now())
                                                {{ \Carbon\Carbon::parse($usuario->created_at)->format('d/m/Y') }}
                                            @else
                                                <span class="text-warning">Data inválida</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                $tipoText = '';
                                                $tipoClass = '';
                                                switch($usuario->tipo) {
                                                    case '2':
                                                        $tipoText = 'SaaS';
                                                        $tipoClass = 'bg-success text-white';
                                                        break;
                                                    case '3':
                                                        $tipoText = 'Admin';
                                                        $tipoClass = 'bg-warning text-white';
                                                        break;
                                                    default:
                                                        $tipoText = 'Usuário';
                                                        $tipoClass = 'bg-secondary text-white';
                                                }
                                            @endphp
                                            <span class="badge {{ $tipoClass }} px-12 py-2 rounded-pill fw-medium text-xs">
                                                {{ $tipoText }}
                                            </span>
                                        </td>
                                        <td>
                                            @php
                                                $statusClass = '';
                                                $statusText = '';
                                                if ($usuario->assinatura && $usuario->assinatura != '0000-00-00') {
                                                    try {
                                                        $dataAssinatura = \Carbon\Carbon::parse($usuario->assinatura);
                                                        if ($dataAssinatura > now()) {
                                                            $statusClass = 'bg-success text-white';
                                                            $statusText = 'Ativo';
                                                        } else {
                                                            $statusClass = 'bg-danger text-white';
                                                            $statusText = 'Inativo';
                                                        }
                                                    } catch (\Exception $e) {
                                                        $statusClass = 'bg-warning text-white';
                                                        $statusText = 'Inválido';
                                                    }
                                                } else {
                                                    $statusClass = 'bg-secondary text-white';
                                                    $statusText = 'Sem Assinatura';
                                                }
                                            @endphp
                                            <span class="badge {{ $statusClass }} px-12 py-2 rounded-pill fw-medium text-xs">
                                                {{ $statusText }}
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Aguardar o ApexCharts estar disponível
    function initChart() {
        if (typeof ApexCharts === 'undefined') {
            setTimeout(initChart, 100);
            return;
        }

        var receitaLabels = @json($receitaLabels);
        var receitaRecebido = @json($receitaSeriesRecebido);
        var receitaPrevisto = @json($receitaSeriesPrevisto);

        var graficoReceitaEl = document.querySelector('#revenueLineChart');
        if (graficoReceitaEl && typeof ApexCharts !== 'undefined') {
            var options = {
                series: [
                    {
                        name: 'Recebido',
                        data: receitaRecebido
                    },
                    {
                        name: 'Previsto',
                        data: receitaPrevisto
                    }
                ],
                chart: {
                    type: 'area',
                    height: 320,
                    toolbar: {
                        show: false
                    },
                    zoom: {
                        enabled: false
                    }
                },
                colors: ['#487FFF', '#FF9F29'],
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'smooth',
                    width: 4,
                    lineCap: 'round'
                },
                fill: {
                    type: 'gradient',
                    gradient: {
                        shade: 'light',
                        type: 'vertical',
                        shadeIntensity: 0.5,
                        gradientToColors: ['#487FFF40', '#FF9F2940'],
                        inverseColors: false,
                        opacityFrom: 0.6,
                        opacityTo: 0.2,
                        stops: [0, 100]
                    }
                },
                markers: {
                    size: 0,
                    strokeWidth: 3,
                    hover: {
                        size: 8
                    }
                },
                xaxis: {
                    categories: receitaLabels,
                    axisBorder: {
                        show: false
                    },
                    labels: {
                        style: {
                            fontSize: '14px'
                        }
                    }
                },
                yaxis: {
                    labels: {
                        formatter: function (value) {
                            return 'R$ ' + value.toLocaleString('pt-BR', { minimumFractionDigits: 2 });
                        },
                        style: {
                            fontSize: '14px'
                        }
                    }
                },
                grid: {
                    borderColor: '#D1D5DB',
                    strokeDashArray: 3
                },
                tooltip: {
                    y: {
                        formatter: function (value) {
                            return 'R$ ' + value.toLocaleString('pt-BR', { minimumFractionDigits: 2 });
                        }
                    }
                },
                legend: {
                    position: 'top',
                    horizontalAlign: 'left'
                }
            };

            try {
                var chart = new ApexCharts(graficoReceitaEl, options);
                chart.render();
            } catch (error) {
                console.error('Erro ao criar gráfico ApexCharts:', error);
            }
        }
    }

    initChart();
});
</script>
@endpush
