@extends('layouts.app')

@section('title', 'Meu Perfil')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        @if(session('success'))
        <div class="alert alert-solid alert-success" role="alert">
            <strong>Sucesso!</strong> {{ session('success') }}
        </div>
        @endif

        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-user" aria-hidden="true"></i> Meu Perfil
            </label>
            <hr>

            <div class="row">
                <div class="col-lg-6">
                    <div class="card card-info">
                        <div class="card-header">Informações Pessoais</div>
                        <div class="card-body">
                            <form action="{{ route('perfil.update') }}" method="POST">
                                @csrf
                                
                                <div class="form-group">
                                    <label for="nome">Nome Completo</label>
                                    <input type="text" class="form-control" name="nome" value="{{ Auth::user()->nome }}" required>
                                </div>

                                <div class="form-group">
                                    <label for="login">E-mail (Login)</label>
                                    <input type="email" class="form-control" name="login" value="{{ Auth::user()->login }}" required>
                                </div>

                                <div class="form-group">
                                    <label for="celular">Celular</label>
                                    <input type="text" class="form-control" name="celular" value="{{ Auth::user()->celular }}">
                                </div>

                                <div class="form-group">
                                    <label for="nascimento">Data de Nascimento</label>
                                    <input type="date" class="form-control" name="nascimento" value="{{ Auth::user()->nascimento }}">
                                </div>

                                <div class="form-group">
                                    <label for="cpf">CPF</label>
                                    <input type="text" class="form-control" name="cpf" value="{{ Auth::user()->cpf }}">
                                </div>

                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-check mg-r-5"></i> Atualizar Dados
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card card-info mg-b-20">
                        <div class="card-header">Alterar Senha</div>
                        <div class="card-body">
                            <form action="{{ route('perfil.update') }}" method="POST">
                                @csrf
                                
                                <div class="form-group">
                                    <label for="senha_atual">Senha Atual</label>
                                    <input type="password" class="form-control" name="senha_atual" required>
                                </div>

                                <div class="form-group">
                                    <label for="senha">Nova Senha</label>
                                    <input type="password" class="form-control" name="senha" required>
                                </div>

                                <div class="form-group">
                                    <label for="senha_confirmation">Confirmar Nova Senha</label>
                                    <input type="password" class="form-control" name="senha_confirmation" required>
                                </div>

                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-key mg-r-5"></i> Alterar Senha
                                </button>
                            </form>
                        </div>
                    </div>

                    <div class="card card-info">
                        <div class="card-header">Minha Assinatura</div>
                        <div class="card-body">
                            <p><strong>Status:</strong> 
                                @if(Auth::user()->status == '1')
                                    <span class="badge badge-success">Ativo</span>
                                @else
                                    <span class="badge badge-danger">Inativo</span>
                                @endif
                            </p>
                            <p><strong>Tipo:</strong> 
                                @if(Auth::user()->tipo == '1')
                                    Administrador Master
                                @elseif(Auth::user()->tipo == '2')
                                    Revendedor
                                @else
                                    Cliente
                                @endif
                            </p>
                            @if(Auth::user()->assinatura)
                            <p><strong>Válido até:</strong> {{ Auth::user()->assinatura }}</p>
                            @endif

                            @if(Auth::user()->tipo == '3')
                            <a href="{{ route('planos.index') }}" class="btn btn-success btn-sm mg-t-10">
                                <i class="fa fa-star mg-r-5"></i> Renovar Assinatura
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mg-t-20">
                <div class="col-lg-12">
                    <div class="card card-info">
                        <div class="card-header">Endereço</div>
                        <div class="card-body">
                            <form action="{{ route('perfil.update') }}" method="POST">
                                @csrf
                                
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label for="cep">CEP</label>
                                            <input type="text" class="form-control" name="cep" value="{{ Auth::user()->cep }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-7">
                                        <div class="form-group">
                                            <label for="endereco">Endereço</label>
                                            <input type="text" class="form-control" name="endereco" value="{{ Auth::user()->endereco }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label for="numero">Número</label>
                                            <input type="text" class="form-control" name="numero" value="{{ Auth::user()->numero }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for="bairro">Bairro</label>
                                            <input type="text" class="form-control" name="bairro" value="{{ Auth::user()->bairro }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="cidade">Cidade</label>
                                            <input type="text" class="form-control" name="cidade" value="{{ Auth::user()->cidade }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label for="uf">UF</label>
                                            <input type="text" class="form-control" name="uf" value="{{ Auth::user()->uf }}" maxlength="2">
                                        </div>
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-check mg-r-5"></i> Atualizar Endereço
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

