@extends('layouts.app')

@section('title', 'Configurações')

@push('styles')
<style>
    .hidden {
        display: none;
    }
    
    /* Container de fundo para o breadcrumb */
    .d-flex.flex-wrap.align-items-center.justify-content-between.gap-3.mb-24 ul.d-flex.align-items-center.gap-2 {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 12px;
        padding: 12px 20px;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
    }
    
    .card-disparo {
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .card-disparo:hover {
        transform: translateY(-2px);
    }
</style>
@endpush

@section('content')
<div class="dashboard-main-body">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
  
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold mb-0">Configurações</h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">Configurações</li>
    </ul>
  </div>

  @if(session('success'))
    <script>
      toastr.success('{{ session('success') }}');
    </script>
  @endif

  <div class="col-lg-12">
    <div class="card">
      <div class="card-header">
        <h5 class="card-title mb-0">DADOS DA EMPRESA</h5>
      </div>
      <div class="card-body">
        <form id="configForm" class="row gy-3 needs-validation" novalidate action="{{ route('configuracoes.update') }}" method="POST" enctype="multipart/form-data">
          @csrf
          <div id="alertMessage" class="alert d-none mb-3"></div>
          <input type="hidden" name="edit_emp" value="{{ $user->id }}">

          @if($user->tipo == 1)
            <!-- CAMPOS DE LOGO (SOMENTE SUPER ADMIN) -->
            <div class="col-md-6">
              <label class="form-label">LOGO DA EMPRESA (Modo Claro)</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:image-outline"></iconify-icon>
                </span>
                <input type="file" class="form-control" name="logo_light" accept="image/png" style="height: 42px; padding: 6px;">
              </div>
            </div>
          
            <div class="col-md-6">
              <label class="form-label">LOGO DA EMPRESA (Modo Escuro)</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:image-outline"></iconify-icon>
                </span>
                <input type="file" class="form-control" name="logo_dark" accept="image/png" style="height: 42px; padding: 6px;">
              </div>
            </div>
          @endif

          <div class="col-md-6">
            <label class="form-label">NOME COMERCIAL</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:shop-outline"></iconify-icon>
              </span>
              <input type="text" class="form-control" name="nomecom" value="{{ $user->nomecom ?? '' }}">
              <div class="invalid-feedback">
                Por favor, forneça o nome comercial.
              </div>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">CNPJ</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:document-outline"></iconify-icon>
              </span>
              <input type="text" class="form-control" name="cnpj" value="{{ $user->cnpj ?? '' }}">
              <div class="invalid-feedback">
                Por favor, forneça o CNPJ.
              </div>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">ENDEREÇO</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:map-point-outline"></iconify-icon>
              </span>
              <input type="text" class="form-control" name="enderecom" value="{{ $user->enderecom ?? '' }}">
              <div class="invalid-feedback">
                Por favor, forneça o endereço.
              </div>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">CONTATO</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:phone-outline"></iconify-icon>
              </span>
              <input type="text" class="form-control" name="contato" value="{{ $user->contato ?? '' }}">
              <div class="invalid-feedback">
                Por favor, forneça o contato.
              </div>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">NOVA SENHA</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:lock-outline"></iconify-icon>
              </span>
              <input type="password" class="form-control" name="senha" placeholder="Deixe em branco para manter a senha atual">
            </div>
          </div>

          <div class="col-md-6 {{ $user->tipo != 1 ? 'hidden' : '' }}">
            <label class="form-label">Mensagem Botão Suporte</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:chat-round-dots-outline"></iconify-icon>
              </span>
              <input type="text" class="form-control" name="mensagem_ajuda" value="{{ $user->mensagem_ajuda ?? '' }}">
              <div class="invalid-feedback">
                Por favor, forneça a mensagem de ajuda.
              </div>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">Modelo de Cobrança</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:money-bag-outline"></iconify-icon>
              </span>
              <select class="form-control radius-8 form-select" name="tipopgmto" id="tipopgmto">
                <option value="1" {{ ($user->pagamentos ?? '1') == '1' ? 'selected' : '' }}>Mercado Pago</option>
                <option value="2" {{ ($user->pagamentos ?? '1') == '2' ? 'selected' : '' }}>Sem Gateway</option>
                <option value="4" {{ ($user->pagamentos ?? '1') == '4' ? 'selected' : '' }}>Paghiper</option>
                <option value="5" {{ ($user->pagamentos ?? '1') == '5' ? 'selected' : '' }}>Asaas</option>
              </select>
              <div class="invalid-feedback">
                Por favor, selecione o modelo de cobrança.
              </div>
            </div>
          </div>
          
          <div class="col-md-6">
            <label class="form-label d-block mb-2">Evitar cobrança aos fins de semana</label>
            <div class="form-check">
              <span class="icon">
                <iconify-icon icon="solar:calendar-mark-outline"></iconify-icon>
              </span>
              <input class="form-check-input" type="checkbox" id="nao_cobrar_fim_semana" name="nao_cobrar_fim_semana"
                {{ !empty($user->nao_cobrar_fim_semana) ? 'checked' : '' }}>
              <label class="form-check-label" for="nao_cobrar_fim_semana">
                Não enviar cobranças aos sábados e domingos
              </label>
            </div>
          </div>

          <!-- Tipo de Disparo Automático -->
          <div class="col-md-12">
            <label class="form-label fw-semibold mb-3">
              <iconify-icon icon="solar:document-send-outline" class="me-2"></iconify-icon>
              Tipo de Disparo nas Cobranças Automáticas
            </label>
            
            <div class="row g-3">
              <!-- Opção PIX/QRCode Direto -->
              <div class="col-md-6">
                <input type="radio" 
                       name="auto_cob_usar_link" 
                       id="tipo_pix" 
                       value="0" 
                       class="d-none tipo-disparo-radio"
                       {{ (!isset($user->auto_cob_usar_link) || $user->auto_cob_usar_link == 0) ? 'checked' : '' }}>
                <label class="card card-disparo cursor-pointer h-100 mb-0" for="tipo_pix" style="cursor: pointer; transition: all 0.3s;">
                  <div class="card-body text-center p-4">
                    <iconify-icon icon="solar:qr-code-outline" class="text-primary mb-3" style="font-size: 48px;"></iconify-icon>
                    <h6 class="mb-2">PIX/QRCode Direto</h6>
                    <small class="mb-16 text-secondary-light fw-normal">
                      Gera PIX imediatamente ao enviar a cobrança. Cliente recebe código pronto para pagar.
                    </small>
                  </div>
                </label>
              </div>
              
              <!-- Opção Link de Pagamento -->
              <div class="col-md-6">
                <input type="radio" 
                       name="auto_cob_usar_link" 
                       id="tipo_link" 
                       value="1" 
                       class="d-none tipo-disparo-radio"
                       {{ (isset($user->auto_cob_usar_link) && $user->auto_cob_usar_link == 1) ? 'checked' : '' }}>
                <label class="card card-disparo cursor-pointer h-100 mb-0" for="tipo_link" style="cursor: pointer; transition: all 0.3s;">
                  <div class="card-body text-center p-4">
                    <iconify-icon icon="solar:link-round-outline" class="text-success mb-3" style="font-size: 48px;"></iconify-icon>
                    <h6 class="mb-2">
                      Link de Pagamento
                      <span class="badge bg-success-focus text-success-main ms-1">Recomendado</span>
                    </h6>
                    <small class="mb-16 text-secondary-light fw-normal">
                      Cliente clica no link e gera PIX na hora. Economiza recursos e API calls dos gateways.
                    </small>
                  </div>
                </label>
              </div>
            </div>
            
            <div class="alert alert-info mt-3 mb-0">
              <iconify-icon icon="solar:info-circle-outline" class="me-2"></iconify-icon>
              <strong>Dica:</strong> O Link de Pagamento é ideal para cobranças automáticas pois o PIX só é gerado quando o cliente acessa o link, reduzindo custos com APIs dos gateways de pagamento.
            </div>
          </div>

          <div id="alert-sem-gateway" class="alert alert-danger d-none col-md-12" role="alert">
            No método Sem Gateway, não é necessário utilizar uma plataforma de pagamentos; você pode atribuir seu PIX manualmente.
          </div>

          <div class="col-md-6 {{ $user->tipo != 1 ? 'hidden' : '' }}">
            <label class="form-label">Background Login</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:gallery-outline"></iconify-icon>
              </span>
              <input type="text" class="form-control" name="background" value="{{ $user->background ?? '' }}">
            </div>
          </div>

          <div class="col-md-6 {{ $user->tipo != 1 ? 'hidden' : '' }}">
            <label class="form-label">Icon Favicon</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:image-outline"></iconify-icon>
              </span>
              <input type="file" class="form-control" name="favicon" accept="image/png" style="height: 42px; padding: 6px;">
            </div>
          </div>

          <!-- Campos Mercado Pago -->
          <div id="campos-mercado-pago" class="row col-md-12 p-0 m-0 {{ ($user->pagamentos ?? '1') != '1' ? 'd-none' : '' }}">
            <div class="col-md-6">
              <label class="form-label">Public Key</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:key-outline"></iconify-icon>
                </span>
                <input type="text" class="form-control" name="publicmp" value="{{ $user->publicmp ?? '' }}">
              </div>
            </div>
            <div class="col-md-6">
              <label class="form-label">Token MP</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:lock-outline"></iconify-icon>
                </span>
                <input type="text" class="form-control" name="tokenmp" value="{{ $user->tokenmp ?? '' }}">
              </div>
            </div>
            <div class="col-md-12">
              <a href="https://www.mercadopago.com.br/developers/panel/app" class="btn btn-success btn-sm" target="_blank">Clique Aqui para obter suas credenciais</a><br />
            </div>
          </div>

          <!-- Campos de QR Code e Copia e Cola (exceto para Sem Gateway) -->
          <div id="campos-qr-copy" class="row col-md-12 p-0 m-0 {{ ($user->pagamentos ?? '1') == '2' ? 'd-none' : '' }}">
            <div class="col-md-6">
              <label class="form-label">Chave Copia e Cola</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:copy-outline"></iconify-icon>
                </span>
                <select class="form-control radius-8 form-select" name="msgqr">
                  <option value="1" {{ ($user->msgqr ?? '1') == '1' ? 'selected' : '' }}>Sim</option>
                  <option value="2" {{ ($user->msgqr ?? '1') == '2' ? 'selected' : '' }}>Não</option>
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <label class="form-label">Envia QRCode</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:qr-code-outline"></iconify-icon>
                </span>
                <select class="form-control radius-8 form-select" name="msgpix">
                  <option value="1" {{ ($user->msgpix ?? '1') == '1' ? 'selected' : '' }}>Sim</option>
                  <option value="2" {{ ($user->msgpix ?? '1') == '2' ? 'selected' : '' }}>Não</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Campos Sem Gateway -->
          <div id="campos-sem-gateway" class="row col-md-12 p-0 m-0 {{ ($user->pagamentos ?? '1') != '2' ? 'd-none' : '' }}">
            <div class="col-md-6">
              <label class="form-label">Chave Pix Manual</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:key-outline"></iconify-icon>
                </span>
                <input type="text" class="form-control" name="pix_manual_key" value="{{ $user->pix_manual_key ?? '' }}">
              </div>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">Juros Diários</label>
            <div class="icon-field has-validation">
              <span class="icon">
                <iconify-icon icon="solar:chart-2-outline"></iconify-icon>
              </span>
              <input type="text" class="form-control" name="juros_diarios" value="{{ number_format((float)($user->juros_diarios ?? 0), 2, ',', '.') }}" oninput="this.value = this.value.replace(/,/g, '.')">
            </div>
          </div>
          
          <div id="campos-paghiper" class="row col-md-12 p-0 m-0 {{ ($user->pagamentos ?? '1') != '4' ? 'd-none' : '' }}">
            <div class="col-md-6">
              <label class="form-label">API Key</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:key-outline"></iconify-icon>
                </span>
                <input type="text" class="form-control" name="key_paghiper" value="{{ $user->key_paghiper ?? '' }}">
              </div>
            </div>
            <div class="col-md-6">
              <label class="form-label">Token</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:lock-outline"></iconify-icon>
                </span>
                <input type="text" class="form-control" name="token_paghiper" value="{{ $user->token_paghiper ?? '' }}">
              </div>
            </div>
          </div>

          <!-- Campos Asaas -->
          <div id="campos-asaas" class="row col-md-12 p-0 m-0 {{ ($user->pagamentos ?? '1') != '5' ? 'd-none' : '' }}">
            <div class="col-md-6">
              <label class="form-label">Chave da API Asaas</label>
              <div class="icon-field has-validation">
                <span class="icon">
                  <iconify-icon icon="solar:lock-outline"></iconify-icon>
                </span>
                <input type="text" class="form-control" name="tokenasaas" value="{{ $user->tokenasaas ?? '' }}" placeholder="Sua Chave da API do Asaas">
              </div>
            </div>
            
            <!-- Bloco Webhook Asaas -->
            <div id="webhook-asaas-box" class="col-md-12 mt-3">
              <div class="card card-body p-4 mb-3 border rounded-3 shadow-sm">
                <div class="d-flex align-items-center mb-2">
                  <span class="me-2 text-primary" style="font-size: 1.7rem;">
                    <iconify-icon icon="solar:link-outline"></iconify-icon>
                  </span>
                  <h5 class="mb-0 fw-semibold text-primary">URL do Webhook Asaas</h5>
                </div>
                <div class="mb-2 text-secondary" style="font-size: 1rem;">Configure esta URL no painel do Asaas para receber notificações automáticas:</div>
                <div class="input-group flex-nowrap align-items-center" style="max-width: 100%;">
                  <input type="text" class="form-control form-control-lg border-0 rounded-start text-body" id="webhookUrl" value="{{ $url }}/webhook/asaas" readonly style="font-size:1.1rem; font-family:monospace;">
                  <button class="btn btn-primary d-flex align-items-center px-3 rounded-end" type="button" onclick="copyWebhookUrl()" data-bs-toggle="tooltip" data-bs-placement="top" title="Copiar URL">
                    <iconify-icon icon="solar:copy-outline" style="font-size:1.3rem;"></iconify-icon>
                  </button>
                </div>
                <div class="mt-3 small text-primary fw-semibold">
                  Você pode criar novos Webhooks utilizando a aplicação Web do Asaas.<br>
                  Para isso, acesse: <b>Menu do usuário → Integrações → Webhooks → Novo Webhook</b>
                </div>
              </div>
            </div>
            
            <div class="col-md-12">
              <a href="https://www.asaas.com/api-docs/" class="btn btn-success btn-sm" target="_blank">Clique Aqui para obter suas Chaves da API Asaas</a><br />
            </div>
          </div>

          @if($user->tipo == 1)
            <!-- Servidores Evolution -->
            <div class="col-md-12">
              <div class="card">
                <div class="card-header bg-primary bg-opacity-10">
                  <h5 class="card-title mb-0 text-primary d-flex justify-content-center">Servidores Evolution</h5>
                </div>
                <div class="card-body">
                  <div class="row g-3">
                    <!-- Servidor Principal -->
                    <div class="col-md-6">
                      <div class="card h-100 border">
                        <div class="card-header bg-primary bg-opacity-10 d-flex justify-content-between align-items-center">
                          <h6 class="mb-0 text-primary d-flex align-items-center">
                            <iconify-icon icon="solar:server-outline" class="me-2 text-lg"></iconify-icon>
                            Servidor Principal
                          </h6>
                          <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="servidor_1_ativo" 
                                   value="1" {{ ($user->servidor_1_ativo ?? 1) ? 'checked' : '' }}>
                          </div>
                        </div>
                        <div class="card-body">
                          <div class="mb-3">
                            <label class="form-label">URL da API</label>
                            <div class="icon-field has-validation">
                              <span class="icon">
                                <iconify-icon icon="solar:link-outline"></iconify-icon>
                              </span>
                              <input type="text" class="form-control" name="whatsapp_api" value="{{ $user->whatsapp_api ?? '' }}" placeholder="https://api.evolution.com" style="border-left: 0;">
                            </div>
                          </div>
                          <div class="mb-3">
                            <label class="form-label">Token de Acesso</label>
                            <div class="icon-field has-validation">
                              <span class="icon">
                                <iconify-icon icon="solar:key-outline"></iconify-icon>
                              </span>
                              <input type="text" class="form-control" name="whatsapp_token" value="{{ $user->whatsapp_token ?? '' }}" placeholder="Seu token de acesso" style="border-left: 0;">
                            </div>
                          </div>
                          <div class="mb-3">
                            <label class="form-label">Limite de Conexões</label>
                            <div class="icon-field has-validation">
                              <span class="icon">
                                <iconify-icon icon="solar:users-group-rounded-outline"></iconify-icon>
                              </span>
                              <input type="number" class="form-control" name="servidor_1_limite" value="{{ $user->servidor_1_limite ?? '100' }}" placeholder="Ex: 100" style="border-left: 0;">
                            </div>
                            <small class="mb-16 text-secondary-light fw-normal">Número máximo de conexões simultâneas permitidas</small>
                          </div>
                        </div>
                      </div>
                    </div>

                    <!-- Servidor Secundário -->
                    <div class="col-md-6">
                      <div class="card h-100 border">
                        <div class="card-header bg-secondary bg-opacity-10 d-flex justify-content-between align-items-center">
                          <h6 class="mb-0 text-secondary d-flex align-items-center">
                            <iconify-icon icon="solar:server-2-outline" class="me-2 text-lg"></iconify-icon>
                            Servidor Secundário
                          </h6>
                          <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="servidor_2_ativo" 
                                   value="1" {{ ($user->servidor_2_ativo ?? 0) ? 'checked' : '' }}>
                          </div>
                        </div>
                        <div class="card-body">
                          <div class="mb-3">
                            <label class="form-label">URL da API</label>
                            <div class="icon-field has-validation">
                              <span class="icon">
                                <iconify-icon icon="solar:link-outline"></iconify-icon>
                              </span>
                              <input type="text" class="form-control" name="whatsapp_api_2" value="{{ $user->whatsapp_api_2 ?? '' }}" placeholder="https://api2.evolution.com" style="border-left: 0;">
                            </div>
                          </div>
                          <div class="mb-3">
                            <label class="form-label">Token de Acesso</label>
                            <div class="icon-field has-validation">
                              <span class="icon">
                                <iconify-icon icon="solar:key-outline"></iconify-icon>
                              </span>
                              <input type="text" class="form-control" name="whatsapp_token_2" value="{{ $user->whatsapp_token_2 ?? '' }}" placeholder="Seu token de acesso" style="border-left: 0;">
                            </div>
                          </div>
                          <div class="mb-3">
                            <label class="form-label">Limite de Conexões</label>
                            <div class="icon-field has-validation">
                              <span class="icon">
                                <iconify-icon icon="solar:users-group-rounded-outline"></iconify-icon>
                              </span>
                              <input type="number" class="form-control" name="servidor_2_limite" value="{{ $user->servidor_2_limite ?? '100' }}" placeholder="Ex: 100" style="border-left: 0;">
                            </div>
                            <small class="mb-16 text-secondary-light fw-normal">Número máximo de conexões simultâneas permitidas</small>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- CONFIGURAÇÃO DE EMAIL (APENAS SUPER ADMIN) -->
            <div class="col-12">
              <hr class="my-4">
              <h6 class="fw-semibold mb-3 text-primary d-flex align-items-center">
                <iconify-icon icon="solar:letter-outline" class="me-2 text-xl"></iconify-icon>
                CONFIGURAÇÕES DE EMAIL
              </h6>
            </div>

            <div class="col-md-12">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="email_verification_enabled" name="email_verification_enabled" 
                       {{ ($emailConfig && $emailConfig->email_verification_enabled) ? 'checked' : '' }}>
                <label class="form-check-label" for="email_verification_enabled">
                  <strong>Ativar verificação por email</strong>
                  <br>
                  <small class="mb-16 text-secondary-light text-sm">Quando ativado, novos usuários receberão um email de verificação para confirmar o cadastro</small>
                </label>
              </div>
            </div>

            <div id="email-config-fields" class="row col-md-12 p-0 m-0 {{ ($emailConfig && $emailConfig->email_verification_enabled) ? '' : 'd-none' }}">
              <div class="col-md-6">
                <label class="form-label">Servidor SMTP</label>
                <div class="icon-field has-validation">
                  <span class="icon">
                    <iconify-icon icon="solar:server-outline"></iconify-icon>
                  </span>
                  <input type="text" class="form-control" name="smtp_host" 
                         value="{{ $emailConfig->smtp_host ?? '' }}" 
                         placeholder="Ex: smtp.gmail.com">
                </div>
              </div>

              <div class="col-md-6">
                <label class="form-label">Porta SMTP</label>
                <div class="icon-field has-validation">
                  <span class="icon">
                    <iconify-icon icon="solar:server-outline"></iconify-icon>
                  </span>
                  <input type="number" class="form-control" name="smtp_port" 
                         value="{{ $emailConfig->smtp_port ?? '587' }}" 
                         placeholder="Ex: 587">
                </div>
              </div>

              <div class="col-md-6">
                <label class="form-label">Criptografia</label>
                <div class="icon-field has-validation">
                  <span class="icon">
                    <iconify-icon icon="solar:lock-outline"></iconify-icon>
                  </span>
                  <select class="form-control radius-8 form-select" name="smtp_encryption">
                    <option value="tls" {{ ($emailConfig && $emailConfig->smtp_encryption == 'tls') ? 'selected' : '' }}>TLS</option>
                    <option value="ssl" {{ ($emailConfig && $emailConfig->smtp_encryption == 'ssl') ? 'selected' : '' }}>SSL</option>
                    <option value="none" {{ ($emailConfig && $emailConfig->smtp_encryption == 'none') ? 'selected' : '' }}>Nenhuma</option>
                  </select>
                </div>
              </div>

              <div class="col-md-6">
                <label class="form-label">Usuário SMTP</label>
                <div class="icon-field has-validation">
                  <span class="icon">
                    <iconify-icon icon="solar:user-outline"></iconify-icon>
                  </span>
                  <input type="email" class="form-control" name="smtp_username" 
                         value="{{ $emailConfig->smtp_username ?? '' }}" 
                         placeholder="Ex: seu-email@gmail.com">
                </div>
              </div>

              <div class="col-md-6">
                <label class="form-label">Senha SMTP</label>
                <div class="icon-field has-validation">
                  <span class="icon">
                    <iconify-icon icon="solar:lock-outline"></iconify-icon>
                  </span>
                  <input type="password" class="form-control" name="smtp_password" 
                         value="{{ $emailConfig->smtp_password ?? '' }}" 
                         placeholder="Senha do email ou senha de app">
                </div>
              </div>

              <div class="col-md-6">
                <label class="form-label">Email Remetente</label>
                <div class="icon-field has-validation">
                  <span class="icon">
                    <iconify-icon icon="solar:letter-outline"></iconify-icon>
                  </span>
                  <input type="email" class="form-control" name="from_email" 
                         value="{{ $emailConfig->from_email ?? '' }}" 
                         placeholder="Ex: noreply@suadominio.com">
                </div>
              </div>

              <div class="col-md-6">
                <label class="form-label">Nome do Remetente</label>
                <div class="icon-field has-validation">
                  <span class="icon">
                    <iconify-icon icon="solar:user-outline"></iconify-icon>
                  </span>
                  <input type="text" class="form-control" name="from_name" 
                         value="{{ $emailConfig->from_name ?? '' }}" 
                         placeholder="Ex: Gestor PRO">
                </div>
              </div>

              <div class="col-12">
                <div class="alert alert-info d-flex align-items-start">
                  <iconify-icon icon="solar:info-circle-outline" class="me-2 text-xl flex-shrink-0 mt-1"></iconify-icon>
                  <div>
                    <strong>Dicas para configuração:</strong>
                    <ul class="mb-0 mt-2">
                      <li><strong>Gmail:</strong> smtp.gmail.com, porta 587, TLS</li>
                      <li><strong>Outlook/Hotmail:</strong> smtp-mail.outlook.com, porta 587, TLS</li>
                      <li><strong>Yahoo:</strong> smtp.mail.yahoo.com, porta 587, TLS</li>
                      <li>Para Gmail, use uma <strong>senha de app</strong> em vez da senha normal</li>
                    </ul>
                  </div>
                </div>
              </div>

              <div class="col-12">
                <div class="d-flex gap-2">
                  <button type="button" class="btn btn-success-600 radius-8 px-20 py-11 d-flex align-items-center gap-2" id="testEmailBtn">
                    <iconify-icon icon="solar:letter-outline"></iconify-icon>
                    Testar Conexão SMTP
                  </button>
                  <a href="#" class="btn btn-outline-success-600 radius-8 px-20 py-11 d-flex align-items-center gap-2">
                    <iconify-icon icon="solar:settings-outline"></iconify-icon>
                    Testar Integração
                  </a>
                </div>
                <small class="mb-16 text-secondary-light text-sm d-block mt-2">
                  Clique para testar se as configurações SMTP estão funcionando corretamente
                </small>
              </div>
            </div>

            <!-- SISTEMA DE INDICAÇÃO (APENAS SUPER ADMIN) -->
            <div class="col-12">
              <hr class="my-4">
              <h6 class="fw-semibold mb-3 text-success d-flex align-items-center">
                <iconify-icon icon="solar:users-group-two-rounded-outline" class="me-2 text-xl"></iconify-icon>
                SISTEMA DE INDICAÇÃO
              </h6>
            </div>

            <div class="col-md-12">
              <div class="card border-success">
                <div class="card-header bg-success bg-opacity-10">
                  <h6 class="mb-0 text-success d-flex align-items-center">
                    <iconify-icon icon="solar:hand-money-outline" class="me-2 text-lg"></iconify-icon>
                    Configurações de Recompensas
                  </h6>
                </div>
                <div class="card-body">
                  <div class="row g-3">
                    
                    <!-- Sistema Ativo -->
                    <div class="col-md-12">
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="sistema_indicacao_ativo" 
                               name="sistema_indicacao_ativo" value="1" 
                               {{ ($indicacaoConfig['sistema_ativo'] ?? 1) ? 'checked' : '' }}>
                        <label class="form-check-label" for="sistema_indicacao_ativo">
                          <strong>Ativar Sistema de Indicação</strong>
                          <br>
                          <small class="mb-16 text-secondary-light text-sm">Permite que usuários indiquem novos clientes e ganhem recompensas</small>
                        </label>
                      </div>
                    </div>

                    <!-- Pontos por Indicação -->
                    <div class="col-md-6">
                      <label class="form-label">Valor por Indicação (R$)</label>
                      <div class="icon-field has-validation">
                        <span class="icon">
                          <iconify-icon icon="solar:dollar-outline"></iconify-icon>
                        </span>
                        <input type="number" step="0.01" class="form-control moeda" 
                               name="pontos_por_indicacao" 
                               value="{{ $indicacaoConfig['pontos_por_indicacao'] ?? '10.00' }}" 
                               placeholder="Ex: 10.00" style="border-left: 0;">
                      </div>
                      <small class="mb-16 text-secondary-light text-sm">Valor creditado quando um indicado ativa sua conta</small>
                    </div>

                    <!-- Valor Mínimo para Resgate -->
                    <div class="col-md-6">
                      <label class="form-label">Valor Mínimo para Resgate (R$)</label>
                      <div class="icon-field has-validation">
                        <span class="icon">
                          <iconify-icon icon="solar:wallet-outline"></iconify-icon>
                        </span>
                        <input type="number" step="0.01" class="form-control moeda" 
                               name="minimo_resgate" 
                               value="{{ $indicacaoConfig['minimo_resgate'] ?? '50.00' }}" 
                               placeholder="Ex: 50.00" style="border-left: 0;">
                      </div>
                      <small class="mb-16 text-secondary-light text-sm">Saldo mínimo necessário para solicitar resgate</small>
                    </div>

                    <!-- Expiração de Pontos -->
                    <div class="col-md-6">
                      <label class="form-label">Expiração de Pontos (meses)</label>
                      <div class="icon-field has-validation">
                        <span class="icon">
                          <iconify-icon icon="solar:calendar-outline"></iconify-icon>
                        </span>
                        <input type="number" class="form-control" 
                               name="expiracao_pontos_meses" 
                               value="{{ $indicacaoConfig['expiracao_pontos_meses'] ?? '12' }}" 
                               placeholder="Ex: 12" style="border-left: 0;">
                      </div>
                      <small class="mb-16 text-secondary-light text-sm">Tempo até os pontos expirarem (0 = nunca expira)</small>
                    </div>

                    <!-- Estatísticas -->
                    <div class="col-md-6">
                      <div class="card bg-success-focus border-0">
                        <div class="card-body">
                          <div class="d-flex align-items-center justify-content-between">
                            <div>
                              <h6 class="mb-1 text-success">Total de Indicações</h6>
                              <p class="mb-0 text-muted">Sistema completo</p>
                            </div>
                            <div class="text-end">
                              <h4 class="mb-0 text-success">{{ $totalIndicacoes }}</h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <!-- Informações Adicionais -->
                    <div class="col-12">
                      <div class="alert alert-success d-flex align-items-start">
                        <iconify-icon icon="solar:info-circle-outline" class="me-2 text-xl flex-shrink-0 mt-1"></iconify-icon>
                        <div>
                          <strong>Como funciona:</strong>
                          <ul class="mb-0 mt-2">
                            <li>Usuários recebem um <strong>link único de indicação</strong></li>
                            <li>Novos cadastros via link são vinculados ao indicador</li>
                            <li>Após ativação (pagamento), o indicador recebe os pontos</li>
                            <li>Pontos podem ser usados como <strong>crédito no sistema</strong></li>
                            <li>Sistema rastreia todas as movimentações</li>
                          </ul>
                        </div>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div>
          @endif

          <div class="col-md-12">
            <button class="btn btn-primary-600" type="submit" id="submitBtn">
              <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
              Salvar <i class="fa fa-arrow-right"></i>
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
$(document).ready(function() {
    // Configuração do Toastr
    toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": true,
        "progressBar": true,
        "positionClass": "toast-top-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    };

    // Destacar card selecionado do tipo de disparo
    function atualizarEstiloCardsDisparo() {
        $('.card-disparo').css({
            'border': '1px solid #dee2e6',
            'box-shadow': 'none',
            'transform': 'scale(1)'
        });
        
        const tipoSelecionado = $('input[name="auto_cob_usar_link"]:checked').attr('id');
        if (tipoSelecionado === 'tipo_pix') {
            $('label[for="tipo_pix"]').css({
                'border': '2px solid #0d6efd',
                'box-shadow': '0 4px 12px rgba(13, 110, 253, 0.2)',
                'transform': 'scale(1.02)'
            });
        } else if (tipoSelecionado === 'tipo_link') {
            $('label[for="tipo_link"]').css({
                'border': '2px solid #198754',
                'box-shadow': '0 4px 12px rgba(25, 135, 84, 0.2)',
                'transform': 'scale(1.02)'
            });
        }
    }
    
    // Aplicar estilo inicial
    atualizarEstiloCardsDisparo();
    
    // Atualizar estilo ao mudar seleção
    $('input[name="auto_cob_usar_link"]').on('change', function() {
        atualizarEstiloCardsDisparo();
    });

    // Controle do checkbox de verificação por email
    $('#email_verification_enabled').on('change', function() {
        const isChecked = $(this).is(':checked');
        const emailFields = $('#email-config-fields');
        
        if (isChecked) {
            emailFields.removeClass('d-none').slideDown(300);
        } else {
            emailFields.addClass('d-none').slideUp(300);
        }
    });

    // Teste de conexão SMTP
    $('#testEmailBtn').on('click', function() {
        const btn = $(this);
        const originalText = btn.html();
        
        // Desabilitar botão e mostrar loading
        btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i>Testando...');
        
        // Preparar dados do formulário
        const formData = new FormData();
        formData.append('test_email', '1');
        formData.append('smtp_host', $('input[name="smtp_host"]').val());
        formData.append('smtp_port', $('input[name="smtp_port"]').val());
        formData.append('smtp_username', $('input[name="smtp_username"]').val());
        formData.append('smtp_password', $('input[name="smtp_password"]').val());
        formData.append('smtp_encryption', $('select[name="smtp_encryption"]').val());
        formData.append('from_email', $('input[name="from_email"]').val());
        formData.append('from_name', $('input[name="from_name"]').val());
        formData.append('_token', '{{ csrf_token() }}');
        
        $.ajax({
            url: '{{ route("configuracoes.test-email") }}',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                try {
                    const data = typeof response === 'string' ? JSON.parse(response) : response;
                    if (data.success) {
                        toastr.success('✅ ' + data.message);
                    } else {
                        toastr.error('❌ ' + data.message);
                    }
                } catch (e) {
                    toastr.error('❌ Erro ao processar resposta do servidor');
                }
            },
            error: function() {
                toastr.error('❌ Erro ao conectar com o servidor');
            },
            complete: function() {
                // Restaurar botão
                btn.prop('disabled', false).html(originalText);
            }
        });
    });

    const form = $('#configForm');
    const submitBtn = $('#submitBtn');
    const spinner = submitBtn.find('.spinner-border');

    form.on('submit', function(e) {
        // Remove o required de todos os campos ocultos
        $('#configForm .hidden :input[required]').each(function() {
            $(this).prop('required', false);
        });

        e.preventDefault();
        
        // Validação do formulário
        if (!this.checkValidity()) {
            e.stopPropagation();
            $(this).addClass('was-validated');
            return;
        }

        // Preparar FormData
        const formData = new FormData(this);
        
        // Mostrar spinner e desabilitar botão
        spinner.removeClass('d-none');
        submitBtn.prop('disabled', true);
        
        // Enviar via AJAX
        $.ajax({
            url: form.attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success || response.redirect) {
                    toastr.success('Configurações atualizadas com sucesso!');
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                } else {
                    toastr.error(response.message || 'Erro ao atualizar configurações');
                }
            },
            error: function(xhr, status, error) {
                toastr.error('Erro ao processar a requisição. Tente novamente.');
            },
            complete: function() {
                // Esconder spinner e habilitar botão
                spinner.addClass('d-none');
                submitBtn.prop('disabled', false);
            }
        });
    });

    // Função para controlar a visibilidade dos campos
    function togglePaymentFields() {
        const selectedPayment = $('#tipopgmto').val();
        
        // Esconde todos os campos primeiro
        $('#campos-mercado-pago, #campos-sem-gateway, #campos-paghiper, #campos-asaas').addClass('d-none');
        $('#alert-sem-gateway').addClass('d-none');
        
        // Mostra os campos correspondentes ao tipo selecionado
        switch(selectedPayment) {
            case '1':
                $('#campos-mercado-pago').removeClass('d-none');
                $('#campos-qr-copy').removeClass('d-none');
                break;
            case '2':
                $('#campos-sem-gateway').removeClass('d-none');
                $('#alert-sem-gateway').removeClass('d-none');
                $('#campos-qr-copy').addClass('d-none');
                break;
            case '4':
                $('#campos-paghiper').removeClass('d-none');
                $('#campos-qr-copy').removeClass('d-none');
                break;
            case '5':
                $('#campos-asaas').removeClass('d-none');
                $('#campos-qr-copy').removeClass('d-none');
                break;
        }
    }

    // Executa quando a página carrega
    togglePaymentFields();

    // Executa quando o select muda
    $('#tipopgmto').on('change', togglePaymentFields);
    
    // Função para copiar URL do webhook
    window.copyWebhookUrl = function() {
        const webhookUrl = document.getElementById('webhookUrl');
        webhookUrl.select();
        webhookUrl.setSelectionRange(0, 99999); // Para dispositivos móveis
        
        try {
            document.execCommand('copy');
            toastr.success('URL do webhook copiada para a área de transferência!');
        } catch (err) {
            // Fallback para navegadores modernos
            navigator.clipboard.writeText(webhookUrl.value).then(function() {
                toastr.success('URL do webhook copiada para a área de transferência!');
            }).catch(function() {
                toastr.error('Erro ao copiar URL. Copie manualmente.');
            });
        }
    };

    // Ativar tooltip Bootstrap se disponível
    if (window.bootstrap) {
      var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
      tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
      });
    }
});
</script>
@endpush
