@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Relatório de Comissões</h4>
                    <a href="{{ route('funcionarios.index') }}" class="btn btn-secondary">
                        <i class="fas fa-users"></i> Funcionários
                    </a>
                </div>
                <div class="card-body">
                    <!-- Filtros -->
                    <form method="GET" action="{{ route('comissoes.index') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="periodo" class="form-label">Período</label>
                                <select name="periodo" id="periodo" class="form-select">
                                    <option value="hoje" {{ $periodo == 'hoje' ? 'selected' : '' }}>Hoje</option>
                                    <option value="ontem" {{ $periodo == 'ontem' ? 'selected' : '' }}>Ontem</option>
                                    <option value="ultima_semana" {{ $periodo == 'ultima_semana' ? 'selected' : '' }}>Última Semana</option>
                                    <option value="mes_atual" {{ $periodo == 'mes_atual' ? 'selected' : '' }}>Mês Atual</option>
                                    <option value="mes_passado" {{ $periodo == 'mes_passado' ? 'selected' : '' }}>Mês Passado</option>
                                    <option value="ultimos_30_dias" {{ $periodo == 'ultimos_30_dias' ? 'selected' : '' }}>Últimos 30 Dias</option>
                                    <option value="ultimos_90_dias" {{ $periodo == 'ultimos_90_dias' ? 'selected' : '' }}>Últimos 90 Dias</option>
                                    <option value="ano_atual" {{ $periodo == 'ano_atual' ? 'selected' : '' }}>Ano Atual</option>
                                    <option value="personalizado" {{ $periodo == 'personalizado' ? 'selected' : '' }}>Personalizado</option>
                                </select>
                            </div>
                            <div class="col-md-3" id="dataInicioContainer" style="display: {{ $periodo == 'personalizado' ? 'block' : 'none' }};">
                                <label for="data_inicio" class="form-label">Data Início</label>
                                <input type="date" name="data_inicio" id="data_inicio" class="form-control" value="{{ $dataInicio }}">
                            </div>
                            <div class="col-md-3" id="dataFimContainer" style="display: {{ $periodo == 'personalizado' ? 'block' : 'none' }};">
                                <label for="data_fim" class="form-label">Data Fim</label>
                                <input type="date" name="data_fim" id="data_fim" class="form-control" value="{{ $dataFim }}">
                            </div>
                            <div class="col-md-3">
                                <label for="funcionario_id" class="form-label">Funcionário</label>
                                <select name="funcionario_id" id="funcionario_id" class="form-select">
                                    <option value="todos" {{ $funcionarioId == 'todos' ? 'selected' : '' }}>Todos</option>
                                    @foreach($funcionarios as $func)
                                        <option value="{{ $func->id }}" {{ $funcionarioId == $func->id ? 'selected' : '' }}>{{ $func->nome }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Filtrar</button>
                                <a href="{{ route('comissoes.index') }}" class="btn btn-outline-secondary">Limpar</a>
                            </div>
                        </div>
                    </form>

                    <!-- Estatísticas Gerais -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h6>Total de Comissões</h6>
                                    <h4>R$ {{ number_format($totalComissoes, 2, ',', '.') }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h6>Total de Vendas</h6>
                                    <h4>{{ $totalVendas }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h6>Média por Venda</h6>
                                    <h4>R$ {{ number_format($mediaComissao, 2, ',', '.') }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-warning text-white">
                                <div class="card-body">
                                    <h6>Funcionários Ativos</h6>
                                    <h4>{{ $totalFuncionarios }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Top 3 por Comissão -->
                    @if($topComissao->count() > 0)
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5>Top 3 Funcionários por Comissão</h5>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Posição</th>
                                            <th>Funcionário</th>
                                            <th>% Comissão</th>
                                            <th>Total de Vendas</th>
                                            <th>Total Faturado</th>
                                            <th>Total de Comissões</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($topComissao as $index => $item)
                                            <tr>
                                                <td><strong>#{{ $index + 1 }}</strong></td>
                                                <td>{{ $item->funcionario->nome ?? 'N/A' }}</td>
                                                <td>{{ number_format($item->funcionario->porcentagem_vendas ?? 0, 2, ',', '.') }}%</td>
                                                <td>{{ $item->total_vendas }}</td>
                                                <td>R$ {{ number_format($item->total_faturado, 2, ',', '.') }}</td>
                                                <td><strong style="color: #198754;">R$ {{ number_format($item->total_comissao, 2, ',', '.') }}</strong></td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Lista Completa -->
                    <div class="row">
                        <div class="col-12">
                            <h5>Comissões por Funcionário</h5>
                            @if($funcionariosComissao->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Funcionário</th>
                                                <th>% Comissão</th>
                                                <th>Total de Vendas</th>
                                                <th>Total Faturado</th>
                                                <th>Total de Comissões</th>
                                                <th>Média por Venda</th>
                                                <th>Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($funcionariosComissao as $item)
                                                <tr>
                                                    <td>{{ $item->funcionario->nome ?? 'N/A' }}</td>
                                                    <td>{{ number_format($item->funcionario->porcentagem_vendas ?? 0, 2, ',', '.') }}%</td>
                                                    <td>{{ $item->total_vendas }}</td>
                                                    <td>R$ {{ number_format($item->total_faturado, 2, ',', '.') }}</td>
                                                    <td><strong style="color: #198754;">R$ {{ number_format($item->total_comissao, 2, ',', '.') }}</strong></td>
                                                    <td>R$ {{ number_format($item->media_comissao, 2, ',', '.') }}</td>
                                                    <td>
                                                        @if($item->funcionario)
                                                            <a href="{{ route('comissoes.funcionario', $item->funcionario->id) }}" class="btn btn-sm btn-info">
                                                                <i class="fas fa-eye"></i> Detalhes
                                                            </a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-info">
                                    Nenhuma comissão encontrada no período selecionado.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('#periodo').on('change', function() {
        if ($(this).val() === 'personalizado') {
            $('#dataInicioContainer').show();
            $('#dataFimContainer').show();
        } else {
            $('#dataInicioContainer').hide();
            $('#dataFimContainer').hide();
        }
    });
});
</script>
@endpush
@endsection

