@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Comissões: {{ $funcionario->nome }}</h4>
                    <div>
                        <a href="{{ route('comissoes.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Voltar
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filtros -->
                    <form method="GET" action="{{ route('comissoes.funcionario', $funcionario->id) }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="periodo" class="form-label">Período</label>
                                <select name="periodo" id="periodo" class="form-select">
                                    <option value="hoje" {{ $periodo == 'hoje' ? 'selected' : '' }}>Hoje</option>
                                    <option value="ontem" {{ $periodo == 'ontem' ? 'selected' : '' }}>Ontem</option>
                                    <option value="ultima_semana" {{ $periodo == 'ultima_semana' ? 'selected' : '' }}>Última Semana</option>
                                    <option value="mes_atual" {{ $periodo == 'mes_atual' ? 'selected' : '' }}>Mês Atual</option>
                                    <option value="mes_anterior" {{ $periodo == 'mes_anterior' ? 'selected' : '' }}>Mês Anterior</option>
                                    <option value="ultimos_30_dias" {{ $periodo == 'ultimos_30_dias' ? 'selected' : '' }}>Últimos 30 Dias</option>
                                    <option value="personalizado" {{ $periodo == 'personalizado' ? 'selected' : '' }}>Personalizado</option>
                                </select>
                            </div>
                            <div class="col-md-3" id="dataInicioContainer" style="display: {{ $periodo == 'personalizado' ? 'block' : 'none' }};">
                                <label for="data_inicio" class="form-label">Data Início</label>
                                <input type="date" name="data_inicio" id="data_inicio" class="form-control" value="{{ $dataInicio }}">
                            </div>
                            <div class="col-md-3" id="dataFimContainer" style="display: {{ $periodo == 'personalizado' ? 'block' : 'none' }};">
                                <label for="data_fim" class="form-label">Data Fim</label>
                                <input type="date" name="data_fim" id="data_fim" class="form-control" value="{{ $dataFim }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">&nbsp;</label>
                                <div>
                                    <button type="submit" class="btn btn-primary">Filtrar</button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- Estatísticas -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h6>Total de Vendas</h6>
                                    <h4>{{ $totalVendas }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h6>Total Faturado</h6>
                                    <h4>R$ {{ number_format($totalFaturado, 2, ',', '.') }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h6>Total de Comissões</h6>
                                    <h4>R$ {{ number_format($totalComissao, 2, ',', '.') }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-warning text-white">
                                <div class="card-body">
                                    <h6>Média por Venda</h6>
                                    <h4>R$ {{ number_format($mediaComissao, 2, ',', '.') }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Comissões por Mês -->
                    @if($comissoesPorMes->count() > 0)
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5>Comissões por Mês (Últimos 6 Meses)</h5>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Mês/Ano</th>
                                            <th>Total de Vendas</th>
                                            <th>Total de Comissões</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($comissoesPorMes as $item)
                                            <tr>
                                                <td>{{ \Carbon\Carbon::create($item->ano, $item->mes, 1)->format('m/Y') }}</td>
                                                <td>{{ $item->total_vendas }}</td>
                                                <td><strong style="color: #198754;">R$ {{ number_format($item->total_comissao, 2, ',', '.') }}</strong></td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Lista de Vendas -->
                    <div class="row">
                        <div class="col-12">
                            <h5>Vendas do Funcionário</h5>
                            @if($vendas->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Data</th>
                                                <th>Cliente</th>
                                                <th>Total</th>
                                                <th>Comissão</th>
                                                <th>Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($vendas as $venda)
                                                <tr>
                                                    <td>#{{ $venda->id }}</td>
                                                    <td>{{ $venda->data_venda->format('d/m/Y H:i') }}</td>
                                                    <td>{{ $venda->cliente->nome ?? 'Cliente não informado' }}</td>
                                                    <td>R$ {{ number_format($venda->total, 2, ',', '.') }}</td>
                                                    <td><strong style="color: #198754;">R$ {{ number_format($venda->comissao, 2, ',', '.') }}</strong></td>
                                                    <td>
                                                        <a href="{{ route('pdv.vendas.show', $venda->id) }}" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <div class="mt-3">
                                    {{ $vendas->links() }}
                                </div>
                            @else
                                <div class="alert alert-info">
                                    Nenhuma venda encontrada no período selecionado.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('#periodo').on('change', function() {
        if ($(this).val() === 'personalizado') {
            $('#dataInicioContainer').show();
            $('#dataFimContainer').show();
        } else {
            $('#dataInicioContainer').hide();
            $('#dataFimContainer').hide();
        }
    });
});
</script>
@endpush
@endsection

