@extends('layouts.app')

@section('title', 'Detalhes do Cliente')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <div class="row mg-b-20">
                <div class="col-lg-6">
                    <label class="section-title">
                        <i class="fa fa-user" aria-hidden="true"></i> Detalhes do Cliente
                    </label>
                </div>
                <div class="col-lg-6 text-right">
                    <a href="{{ route('clientes.edit', $cliente->id) }}" class="btn btn-warning btn-sm">
                        <i class="fa fa-pencil mg-r-5"></i> Editar
                    </a>
                    <a href="{{ route('clientes.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                    </a>
                </div>
            </div>
            <hr>

            <div class="row">
                <div class="col-lg-6">
                    <div class="card card-info">
                        <div class="card-header">Informações Pessoais</div>
                        <div class="card-body">
                            <p><strong>Nome:</strong> {{ $cliente->nome }}</p>
                            <p><strong>Celular:</strong> {{ $cliente->celular }}</p>
                            <p><strong>E-mail:</strong> {{ $cliente->email ?? '-' }}</p>
                            <p><strong>CPF/CNPJ:</strong> {{ $cliente->cpf_cnpj ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card card-info">
                        <div class="card-header">Endereço</div>
                        <div class="card-body">
                            <p><strong>CEP:</strong> {{ $cliente->cep ?? '-' }}</p>
                            <p><strong>Endereço:</strong> {{ $cliente->endereco ?? '-' }}, {{ $cliente->numero ?? 'S/N' }}</p>
                            <p><strong>Bairro:</strong> {{ $cliente->bairro ?? '-' }}</p>
                            <p><strong>Cidade/UF:</strong> {{ $cliente->cidade ?? '-' }} / {{ $cliente->estado ?? '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            @if($cliente->observacoes)
            <div class="row mg-t-20">
                <div class="col-lg-12">
                    <div class="card card-info">
                        <div class="card-header">Observações</div>
                        <div class="card-body">
                            {{ $cliente->observacoes }}
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <div class="row mg-t-20">
                <div class="col-lg-12">
                    <div class="card card-info">
                        <div class="card-header">Histórico Financeiro</div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Data</th>
                                            <th>Descrição</th>
                                            <th>Valor</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="4" class="text-center">Nenhum registro encontrado</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

