@extends('layouts.app')

@section('title', 'Editar Categoria')

@section('content')
<div class="dashboard-main-body">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
      <span class="text-secondary-light text-sm fw-medium d-block">Cadastros</span>
      <h6 class="fw-semibold mb-0 text-primary-light">Editar Categoria</h6>
    </div>
    <ul class="d-flex align-items-center gap-2 mb-0">
      <li class="fw-medium text-secondary-light">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li class="text-secondary-light">/</li>
      <li class="fw-medium text-secondary-light">
        <a href="{{ route('categorias.index') }}" class="hover-text-primary">Categorias</a>
      </li>
      <li class="text-secondary-light">/</li>
      <li class="fw-medium text-secondary-light">Editar</li>
    </ul>
  </div>

  <div class="card bg-base border border-neutral-200 radius-16 shadow-sm">
    <div class="card-header border-0 pb-0">
      <div class="d-flex flex-column flex-lg-row align-items-lg-center justify-content-between gap-3">
        <div>
          <h5 class="fw-semibold text-primary-light mb-4">Editar Categoria</h5>
          <p class="text-secondary-light text-sm mb-0">Atualize os dados da categoria.</p>
        </div>
        <a href="{{ route('categorias.index') }}" class="btn btn-outline-primary-600 radius-12 px-20 py-11 d-flex align-items-center gap-2">
          <iconify-icon icon="solar:arrow-left-outline" class="text-xl"></iconify-icon>
          Voltar
        </a>
      </div>
    </div>
    <div class="card-body pt-16">
      <form id="formulario" action="{{ route('categorias.update', $categoria->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row">
          <div class="col-md-8">
            <div class="form-group mb-20">
              <label class="form-label fw-semibold text-primary-light text-sm mb-8">Nome</label>
              <input type="text" class="form-control radius-12 h-48-px" name="nome" id="nome" value="{{ old('nome', $categoria->nome) }}" maxlength="160" onkeydown="upperCaseF(this)" required>
              @error('nome')
                <span class="text-danger text-xs mt-4 d-block">{{ $message }}</span>
              @enderror
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group mb-20">
              <label class="form-label fw-semibold text-primary-light text-sm mb-8">Tipo</label>
              <select class="form-control radius-12 h-48-px" name="tipo" id="tipo" required>
                <option value="produto" {{ ($categoria->tipo ?? 'produto') == 'produto' ? 'selected' : '' }}>Produto</option>
                <option value="cliente" {{ ($categoria->tipo ?? '') == 'cliente' ? 'selected' : '' }}>Cliente</option>
              </select>
              @error('tipo')
                <span class="text-danger text-xs mt-4 d-block">{{ $message }}</span>
              @enderror
            </div>
          </div>
        </div>

        <hr class="my-24">

        <div class="row">
          <div class="col-md-12">
            <div class="d-flex justify-content-center gap-2">
              <button type="submit" class="btn btn-primary-600 radius-12 px-24 py-12 d-flex align-items-center gap-2">
                <iconify-icon icon="solar:check-circle-outline" class="text-xl"></iconify-icon>
                Salvar
              </button>
              <a href="{{ route('categorias.index') }}" class="btn btn-outline-primary-600 radius-12 px-24 py-12 d-flex align-items-center gap-2">
                <iconify-icon icon="solar:arrow-left-outline" class="text-xl"></iconify-icon>
                Cancelar
              </a>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
function upperCaseF(a) {
  setTimeout(function() {
    a.value = a.value.toUpperCase();
  }, 1);
}
</script>
@endpush
