<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>{{ $nomesistema ?? 'Gestor PRO' }} - Login</title>
    
    <link rel="icon" href="{{ $favicon }}" type="image/png">
    <link href="{{ asset('lib/font-awesome/css/font-awesome.css') }}" rel="stylesheet">
    <link href="{{ asset('lib/Ionicons/css/ionicons.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('styles/dark-mode.css') }}">
    <link rel="stylesheet" href="{{ asset('css/slim.css') }}">
    
    <style>
        body {
            color: #000;
            overflow-x: hidden;
            height: 100%;
            background: linear-gradient(45deg, #D96D00 50%, #EEEEEE 50%);
            background-repeat: no-repeat;
            @if($background)
            background-image: url('{{ $background }}');
            background-size: cover;
            @endif
        }

        .signin-box {
            background-color: white;
        }

        .card0 {
            box-shadow: 0px 4px 8px 0px #757575;
            border-radius: 10px;
        }

        input {
            padding: 10px 12px;
            border: 1px solid lightgrey;
            border-radius: 4px;
            margin-bottom: 25px;
            margin-top: 2px;
            width: 100%;
            box-sizing: border-box;
            color: #2C3E50;
            font-size: 14px;
            background-color: #ECEFF1;
        }

        input:focus {
            box-shadow: none !important;
            border: 1px solid #304FFE;
            outline-width: 0;
        }

        .btn-blue {
            background-color: #304FFE;
            width: 100%;
            color: #fff;
            border-radius: 6px;
        }

        .btn-blue:hover {
            background-color: #0D47A1;
            cursor: pointer;
        }
    </style>
</head>

<body>
    <div class="signin-wrapper">
        <div class="signin-box" align="center">
            <h3>{{ $nomesistema }}</h3>
            <hr />

            <form id="loginForm">
                @csrf
                <div class="form-group">
                    <input type="text" class="form-control" id="login" name="login" placeholder="Login" required>
                </div>

                <div class="form-group">
                    <input type="password" class="form-control" id="password" name="password" placeholder="Senha" maxlength="16" required>
                </div>

                @if(session('error'))
                <div class="form-group" style="color:#FF0000">
                    <i class="fa fa-certificate"></i> {{ session('error') }}
                </div>
                @endif

                @if(session('success'))
                <div class="form-group" style="color:#00AA00">
                    <i class="fa fa-check"></i> {{ session('success') }}
                </div>
                @endif

                <button type="submit" id="submit" name="submit" class="btn btn-dark btn-block">Entrar</button>
            </form>

            <a href="{{ route('register') }}" class="btn btn-info btn-block mg-t-10">Nova Conta</a>
            <a href="{{ route('recover') }}" class="btn btn-danger btn-block mg-t-10">Recuperar Senha</a>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.min.css">
    
    <script>
        $(document).ready(function() {
            $("#loginForm").submit(function(e) {
                e.preventDefault();

                var login = $("#login").val();
                var password = $("#password").val();

                $.ajax({
                    url: '{{ route("login.submit") }}',
                    type: 'post',
                    data: {
                        _token: '{{ csrf_token() }}',
                        login: login,
                        password: password,
                    },
                    success: function(response) {
                        if (response.status == 'success') {
                            $.toast({
                                heading: 'Sucesso',
                                text: response.message,
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-right'
                            });
                            
                            // Redireciona após 1 segundo
                            setTimeout(function() {
                                window.location.href = response.redirect;
                            }, 1000);
                        } else {
                            $.toast({
                                heading: 'Erro',
                                text: response.message,
                                showHideTransition: 'slide',
                                icon: 'error',
                                position: 'top-right'
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Erro no login:', error);
                        $.toast({
                            heading: 'Erro',
                            text: 'Ocorreu um erro ao processar o login. Tente novamente.',
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-right'
                        });
                    }
                });
            });
        });
    </script>
</body>
</html>

