<?php

namespace Database\Seeders;

use App\Models\Carteira;
use Illuminate\Database\Seeder;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Verifica se já existe um registro com id=1
        $admin = Carteira::find(1);
        
        if (!$admin) {
            // Cria o admin com ID 1 (necessário para o sistema)
            Carteira::insert([
                'id' => 1,
                'nome' => 'Administrador',
                'login' => 'admin@admin.com',
                'senha' => sha1('admin123'), // Senha: admin123
                'celular' => '00000000000',
                'tipo' => '1', // Admin
                'status' => '1', // Ativo
                'idm' => '1',
                'nomecom' => 'Gestor PRO',
                'assinatura' => '31/12/2099', // Assinatura vitalícia
                'pagamentos' => '1', // 1 = pagamentos ativos
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            
            $this->command->info('✅ Usuário admin criado com sucesso!');
            $this->command->info('📧 Login: admin@admin.com');
            $this->command->info('🔑 Senha: admin123');
        } else {
            // Atualiza o admin existente se necessário
            if ($admin->tipo != '1') {
                $admin->update([
                    'tipo' => '1',
                    'status' => '1',
                    'nomecom' => $admin->nomecom ?? 'Gestor PRO',
                    'assinatura' => '31/12/2099',
                ]);
                $this->command->info('✅ Usuário admin atualizado!');
            } else {
                $this->command->info('ℹ️ Usuário admin já existe.');
            }
        }
    }
}

