<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('planos', function (Blueprint $table) {
            // Verificar se as colunas já existem antes de adicionar
            if (!Schema::hasColumn('planos', 'cadastros_lim')) {
                $table->integer('cadastros_lim')->nullable()->comment('Limite de cadastros permitido neste plano')->after('destaque');
            }
            if (!Schema::hasColumn('planos', 'instancias_limite')) {
                $table->integer('instancias_limite')->nullable()->comment('Limite de instâncias WhatsApp permitido neste plano')->after('cadastros_lim');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('planos', function (Blueprint $table) {
            $table->dropColumn(['cadastros_lim', 'instancias_limite']);
        });
    }
};
