<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('financeiro3', function (Blueprint $table) {
            // Verificar se as colunas já existem antes de adicionar
            if (!Schema::hasColumn('financeiro3', 'dataentrada')) {
                $table->datetime('dataentrada')->nullable()->default(now())->after('idm');
            }
            if (!Schema::hasColumn('financeiro3', 'tipo')) {
                $table->string('tipo', 20)->default('saida')->comment('saida = despesa, entrada = receita')->after('observacao');
            }
            if (!Schema::hasColumn('financeiro3', 'categoria')) {
                $table->string('categoria', 100)->nullable()->after('tipo');
            }
            if (!Schema::hasColumn('financeiro3', 'categoria_id')) {
                $table->unsignedBigInteger('categoria_id')->nullable()->comment('ID da categoria financeira')->after('categoria');
            }
            if (!Schema::hasColumn('financeiro3', 'recorrente')) {
                $table->boolean('recorrente')->default(false)->after('categoria_id');
            }
            if (!Schema::hasColumn('financeiro3', 'frequencia')) {
                $table->string('frequencia', 20)->nullable()->after('recorrente');
            }
            if (!Schema::hasColumn('financeiro3', 'data_final')) {
                $table->date('data_final')->nullable()->after('frequencia');
            }
            if (!Schema::hasColumn('financeiro3', 'origem_recorrente_id')) {
                $table->integer('origem_recorrente_id')->nullable()->after('data_final');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('financeiro3', function (Blueprint $table) {
            $table->dropColumn([
                'dataentrada',
                'tipo',
                'categoria',
                'categoria_id',
                'recorrente',
                'frequencia',
                'data_final',
                'origem_recorrente_id'
            ]);
        });
    }
};
