<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('_pdv_vendas', function (Blueprint $table) {
            $table->id();
            $table->integer('idm')->comment('ID do usuário master');
            $table->unsignedBigInteger('caixa_id');
            $table->unsignedBigInteger('cliente_id')->nullable();
            $table->unsignedBigInteger('funcionario_id')->nullable();
            $table->decimal('total', 10, 2);
            $table->decimal('desconto', 10, 2)->default(0);
            $table->string('forma_pagamento', 50)->nullable();
            $table->dateTime('data_venda');
            $table->enum('status', ['ativa', 'cancelada', 'trocada'])->default('ativa');
            $table->decimal('comissao', 10, 2)->default(0);
            $table->timestamps();

            $table->index('idm');
            $table->index('data_venda');
            $table->index('status');
            
            $table->foreign('idm')->references('Id')->on('carteira')->onDelete('cascade');
            $table->foreign('caixa_id')->references('id')->on('_pdv_caixa')->onDelete('cascade');
            $table->foreign('cliente_id')->references('Id')->on('clientes')->onDelete('set null');
            $table->foreign('funcionario_id')->references('id')->on('funcionarios')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('_pdv_vendas');
    }
};

