<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('whatsapp_envios', function (Blueprint $table) {
            $table->id();
            $table->integer('idm')->comment('ID do usuário (carteira)');
            $table->datetime('data_envio');
            $table->enum('status', ['sucesso', 'falha', 'pendente'])->default('pendente');
            $table->string('tipo', 50)->nullable()->comment('cobranca, pix_codigo, boleto_codigo, pix_manual');
            $table->integer('gateway')->nullable()->comment('1=Mercado Pago, 2=PIX Manual, 4=PagHiper, 5=Asaas');
            $table->string('cliente_nome', 255)->nullable();
            $table->string('telefone', 20);
            $table->decimal('valor', 10, 2)->nullable();
            $table->text('origem')->nullable();
            $table->text('erro')->nullable();
            $table->timestamps();
            
            $table->index('idm');
            $table->index('data_envio');
            $table->index('status');
            $table->index('gateway');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whatsapp_envios');
    }
};

