<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Verificar se a coluna e tabela existem antes de adicionar a foreign key
        if (Schema::hasColumn('carteira', 'plano_id') && Schema::hasTable('planos')) {
            Schema::table('carteira', function (Blueprint $table) {
                try {
                    $table->foreign('plano_id')->references('id')->on('planos')->onDelete('set null');
                } catch (\Exception $e) {
                    // Foreign key já existe, ignorar
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('carteira', function (Blueprint $table) {
            $table->dropForeign(['plano_id']);
        });
    }
};

