<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financeiro3', function (Blueprint $table) {
            $table->id();
            $table->string('idm', 9)->nullable(); // ID do usuário (carteira)
            $table->datetime('dataentrada')->nullable()->default(now());
            $table->decimal('valor', 10, 2)->nullable();
            $table->string('datavencimento', 20)->nullable();
            $table->string('datapagamento', 20)->nullable();
            $table->string('status', 2)->nullable(); // 0=Pendente, 1=Pago
            $table->string('descricao', 120)->nullable();
            $table->text('observacao')->nullable();
            $table->string('tipo', 20)->default('saida')->comment('saida = despesa, entrada = receita');
            $table->string('categoria', 100)->nullable();
            $table->unsignedBigInteger('categoria_id')->nullable()->comment('ID da categoria financeira');
            $table->boolean('recorrente')->default(false);
            $table->string('frequencia', 20)->nullable();
            $table->date('data_final')->nullable();
            $table->integer('origem_recorrente_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financeiro3');
    }
};

