<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clientes', function (Blueprint $table) {
            $table->id();
            $table->string('idm', 9)->nullable(); // ID do usuário (carteira)
            $table->string('idc', 9)->nullable(); // ID da categoria
            $table->decimal('valor', 10, 2)->default(0.00);
            $table->timestamp('entrada')->nullable()->useCurrent();
            $table->string('vjurus', 5)->default('100');
            $table->string('login', 15)->nullable();
            $table->string('senha', 60)->nullable();
            $table->string('tipo', 2)->default('1');
            $table->string('status', 2)->default('1');
            $table->string('nome', 120)->nullable();
            $table->string('nascimento', 15)->nullable();
            $table->string('cpf', 25)->nullable();
            $table->string('celular', 255)->nullable();
            $table->string('email', 120)->nullable();
            $table->string('rg', 20)->nullable();
            $table->string('emissao', 30)->nullable();
            $table->string('uf2', 6)->nullable();
            $table->string('mae', 60)->nullable();
            $table->text('id_asaas')->nullable();
            $table->string('foto', 255)->nullable()->comment('Caminho completo da foto do cliente');
            
            // Endereço
            $table->string('cep', 25)->nullable();
            $table->string('endereco', 120)->nullable();
            $table->string('numero', 9)->nullable();
            $table->string('bairro', 60)->nullable();
            $table->string('complemento', 60)->nullable();
            $table->string('cidade', 30)->nullable();
            $table->string('uf', 5)->nullable();
            $table->string('estado', 5)->nullable();
            $table->text('observacoes')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clientes');
    }
};
