<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carteira', function (Blueprint $table) {
            $table->integer('Id')->primary(); // Usar Id como no legado
            $table->string('idm', 9)->nullable();
            $table->string('valor', 250)->nullable();
            $table->timestamp('entrada')->nullable()->useCurrent();
            $table->string('vjurus', 255)->nullable();
            $table->string('login', 255)->nullable();
            $table->string('senha', 60)->nullable();
            $table->string('tipo', 2)->default('1'); // 1=Admin, 2=Revendedor, 3+=User
            $table->enum('roles', ['superadmin', 'master'])->default('master');
            $table->string('status', 2)->default('1');
            $table->string('nome', 120)->nullable();
            $table->string('celular', 255)->nullable();
            $table->string('nascimento', 15)->nullable();
            $table->string('cpf', 25)->nullable();
            $table->string('email', 120)->nullable();
            $table->string('cep', 25)->nullable();
            $table->string('endereco', 120)->nullable();
            $table->string('numero', 9)->nullable();
            $table->string('bairro', 60)->nullable();
            $table->string('complemento', 60)->nullable();
            $table->string('cidade', 30)->nullable();
            $table->string('uf', 5)->nullable();
            
            // Tokens de pagamento
            $table->string('tokenmp', 255)->nullable();
            $table->string('tokenasaas', 255)->nullable();
            $table->string('publicmp', 255)->nullable();
            $table->string('client_id_asaas', 255)->nullable();
            
            // Gerencianet/Efí
            $table->string('gerecianet_client', 255)->nullable();
            $table->string('gerecianet_secret', 255)->nullable();
            $table->mediumText('certificado_pem')->nullable();
            $table->string('chave_pix', 255)->nullable();
            
            // PagHiper
            $table->string('key_paghiper', 255)->nullable();
            $table->string('token_paghiper', 255)->nullable();
            
            // Empresa
            $table->string('nomecom', 160)->nullable();
            $table->string('cnpj', 30)->nullable();
            $table->string('enderecom', 160)->nullable();
            $table->string('contato', 15)->nullable();
            
            // Configurações
            $table->string('msg', 2)->default('1');
            $table->string('msgqr', 2)->default('1');
            $table->string('msgpix', 2)->default('1');
            $table->string('tokenapi', 60)->nullable();
            $table->string('pagamentos', 2)->default('1');
            $table->string('assinatura', 10)->nullable();
            $table->string('background', 255)->nullable();
            $table->decimal('juros_diarios', 10, 2)->default(0.00);
            $table->string('favicon', 255)->nullable();
            
            // WhatsApp
            $table->string('whatsapp_api', 255)->nullable();
            $table->string('whatsapp_token', 255)->nullable();
            $table->string('pix_manual_key', 255)->nullable();
            $table->string('premium_zap_name', 255)->nullable();
            $table->string('premium_zap_token', 255)->nullable();
            $table->boolean('premium_zap_checkbox')->default(false);
            
            // Cob. Brasil
            $table->text('cob_brasil')->nullable();
            $table->text('client_id_brasil')->nullable();
            $table->text('client_secret_brasil')->nullable();
            $table->integer('convenio_brasil')->default(0);
            $table->integer('carteira_brasil')->default(0);
            $table->integer('variacao_brasil')->default(0);
            
            // SAAS
            $table->integer('cadastros_lim')->nullable()->comment('Limite de cadastros herdado do plano');
            $table->unsignedInteger('plano_id')->nullable()->comment('Plano associado ao usuário');
            $table->integer('nao_cobrar_fim_semana')->nullable()->comment('0 = cobra FDS, 1 = não cobrar sábados e domingos');
            
            // WhatsApp Multi-servidor
            $table->string('whatsapp_api_2', 255)->nullable();
            $table->string('whatsapp_token_2', 255)->nullable();
            $table->boolean('servidor_1_ativo')->default(false);
            $table->boolean('servidor_2_ativo')->default(false);
            $table->text('mensagem_ajuda')->nullable();
            $table->integer('servidor_1_limite')->default(100);
            $table->integer('servidor_2_limite')->default(100);
            
            // Theme (dark mode) - não existe no legado, mas mantemos para compatibilidade
            // $table->string('theme', 10)->default('light')->comment('Tema: light ou dark');
            
            // Não usar timestamps no legado, mas manteremos para compatibilidade Laravel
            $table->timestamps();
            
            // Foreign key será adicionada em migration separada após criar planos
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carteira');
    }
};
