<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WhatsappEnvio extends Model
{
    use HasFactory;

    protected $table = 'whatsapp_envios';

    protected $fillable = [
        'idm',
        'data_envio',
        'status',
        'tipo',
        'gateway',
        'cliente_nome',
        'telefone',
        'valor',
        'origem',
        'erro',
    ];

    protected $casts = [
        'data_envio' => 'datetime',
        'valor' => 'decimal:2',
    ];

    /**
     * Relacionamento com Carteira
     */
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'Id');
    }

    /**
     * Obter nome do gateway
     */
    public function getGatewayNameAttribute()
    {
        return match($this->gateway) {
            1 => 'Mercado Pago',
            2 => 'PIX Manual',
            4 => 'PagHiper',
            5 => 'Asaas',
            default => 'Gateway ' . ($this->gateway ?? 'N/A'),
        };
    }

    /**
     * Obter nome do tipo formatado
     */
    public function getTipoNomeAttribute()
    {
        return match($this->tipo) {
            'cobranca' => 'Cobrança',
            'pix_codigo' => 'PIX',
            'boleto_codigo' => 'Boleto',
            'pix_manual' => 'PIX Manual',
            default => ucfirst($this->tipo ?? 'N/A'),
        };
    }
}

