<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Omie extends Model
{
    use HasFactory;

    protected $table = 'omie';

    protected $fillable = [
        'idm',
        'appkey',
        'appsecret',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }
}

