<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MessageQueue extends Model
{
    use HasFactory;

    protected $table = 'message_queue';

    protected $fillable = [
        'type',
        'phone',
        'message',
        'media',
        'status',
        'timestamp',
    ];

    protected $casts = [
        'timestamp' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Métodos auxiliares
    public function isPending(): bool
    {
        return $this->status == 'pending';
    }

    public function isSent(): bool
    {
        return $this->status == 'sent';
    }

    public function isFailed(): bool
    {
        return $this->status == 'failed';
    }
}

