<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Fornecedor extends Model
{
    use HasFactory;

    protected $table = 'fornecedores';

    protected $fillable = [
        'idm',
        'nome',
        'contato',
        'telefone',
        'email',
        'endereco',
    ];

    /**
     * Relacionamento com usuário
     */
    public function usuario(): BelongsTo
    {
        return $this->belongsTo(User::class, 'idm', 'id');
    }

    /**
     * Relacionamento com produtos
     */
    public function produtos(): HasMany
    {
        return $this->hasMany(PdvProduto::class, 'fornecedor_id');
    }
}

