<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinanceiroGlobal extends Model
{
    use HasFactory;

    protected $table = 'financeiro_global';

    protected $fillable = [
        'idc',
        'idm',
        'instancia',
        'valorparcela',
        'parcelas',
        'gatewayPayment',
        'type',
        'copiacola',
        'codigobarra',
        'imagemQrcode',
        'id_payment',
        'status_payment',
        'entrada',
    ];

    protected $casts = [
        'valorparcela' => 'decimal:2',
        'parcelas' => 'integer',
        'gatewayPayment' => 'integer',
        'entrada' => 'date',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'idc', 'id');
    }
}

