<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Financeiro1 extends Model
{
    use HasFactory;

    protected $table = 'financeiro1';

    protected $fillable = [
        'idc',
        'idm',
        'idcob',
        'valorsolicitado',
        'taxaj',
        'valorjurus',
        'valorfinal',
        'formapagamento',
        'parcelas',
        'primeiraparcela',
        'chave',
        'status',
        'vparcela',
        'pagoem',
        'entrada',
        'gatewayPayment',
    ];

    protected $casts = [
        'valorsolicitado' => 'decimal:2',
        'valorjurus' => 'decimal:2',
        'valorfinal' => 'decimal:2',
        'vparcela' => 'decimal:2',
        'gatewayPayment' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'idc', 'id');
    }

    public function parcelas()
    {
        return $this->hasMany(Financeiro2::class, 'chave', 'chave');
    }

    // Métodos auxiliares
    public function isAberto(): bool
    {
        return $this->status == '1';
    }

    public function isQuitado(): bool
    {
        return $this->status == '2';
    }
}

