<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cliente extends Model
{
    use HasFactory;

    protected $table = 'clientes';

    protected $fillable = [
        'idm',
        'idc',
        'nome',
        'nascimento',
        'cpf',
        'celular',
        'email',
        'cep',
        'endereco',
        'numero',
        'bairro',
        'cidade',
        'estado',
        'observacoes',
        'id_asaas',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }

    public function categoria()
    {
        return $this->belongsTo(Categoria::class, 'idc', 'id');
    }

    public function financeiro1()
    {
        return $this->hasMany(Financeiro1::class, 'idc', 'id');
    }

    public function financeiro2()
    {
        return $this->hasMany(Financeiro2::class, 'idc', 'id');
    }

    // Métodos auxiliares
    public function getCelularFormatadoAttribute()
    {
        return preg_replace('/(\d{2})(\d{5})(\d{4})/', '($1) $2-$3', $this->celular);
    }

    public function getCpfFormatadoAttribute()
    {
        if (strlen($this->cpf) == 11) {
            return preg_replace('/(\d{3})(\d{3})(\d{3})(\d{2})/', '$1.$2.$3-$4', $this->cpf);
        }
        return preg_replace('/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/', '$1.$2.$3/$4-$5', $this->cpf);
    }
}

