<?php

namespace App\Http\Middleware;

use App\Services\LicenseService;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckLicense
{
    protected LicenseService $licenseService;

    public function __construct(LicenseService $licenseService)
    {
        $this->licenseService = $licenseService;
    }

    /**
     * Handle an incoming request.
     * 
     * Valida a licença do sistema consultando API externa
     * Compatível com o sistema legado
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Se estiver em ambiente de desenvolvimento, pula validação
        if (config('app.env') === 'local' && config('app.debug')) {
            session([
                'license_version' => config('app.version', '1.1.0'),
                'license_expiration' => '31/12/2099',
                'license_valid' => true,
            ]);
            return $next($request);
        }

        // Valida a licença
        $validation = $this->licenseService->validateLicense();

        // Se a licença não é válida, redireciona para logout
        if (!$validation['valid'] || !$validation['response']) {
            return redirect()->route('logout')->with('error', 'Licença inválida. Contate o suporte.');
        }

        // Salva informações da licença na sessão
        session([
            'license_version' => $validation['version'] ?? config('app.version', '1.1.0'),
            'license_expiration' => $validation['expiration_date'] ?? null,
            'license_valid' => true,
        ]);

        return $next($request);
    }
}

