<?php

namespace App\Http\Controllers\Pdv;

use App\Http\Controllers\Controller;
use App\Models\PdvFormaPagamento;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FormaPagamentoController extends Controller
{
    /**
     * Lista todas as formas de pagamento
     */
    public function index()
    {
        $user = Auth::user();
        
        $formasPagamento = PdvFormaPagamento::where('idm', $user->id)
            ->orderBy('nome')
            ->get();

        return view('pdv.formas-pagamento.index', compact('formasPagamento'));
    }

    /**
     * Salva nova forma de pagamento
     */
    public function store(Request $request)
    {
        $user = Auth::user();

        $request->validate([
            'nome' => 'required|string|max:50',
        ]);

        PdvFormaPagamento::create([
            'idm' => $user->id,
            'nome' => $request->nome,
        ]);

        return redirect()->route('pdv.formas-pagamento.index')
            ->with('success', 'Forma de pagamento cadastrada com sucesso!');
    }

    /**
     * Atualiza forma de pagamento
     */
    public function update(Request $request, PdvFormaPagamento $formaPagamento)
    {
        $user = Auth::user();

        if ($formaPagamento->idm !== $user->id) {
            abort(403);
        }

        $request->validate([
            'nome' => 'required|string|max:50',
        ]);

        $formaPagamento->update([
            'nome' => $request->nome,
        ]);

        return redirect()->route('pdv.formas-pagamento.index')
            ->with('success', 'Forma de pagamento atualizada com sucesso!');
    }

    /**
     * Remove forma de pagamento
     */
    public function destroy(PdvFormaPagamento $formaPagamento)
    {
        $user = Auth::user();

        if ($formaPagamento->idm !== $user->id) {
            abort(403);
        }

        $formaPagamento->delete();

        return redirect()->route('pdv.formas-pagamento.index')
            ->with('success', 'Forma de pagamento excluída com sucesso!');
    }
}

