<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Auth;

class MenuHelper
{
    public static function getMenuItems()
    {
        $user = Auth::user();
        $userRole = $user->tipo == '1' ? 'superadmin' : ($user->roles ?? 'master');
        
        // Verificar se é funcionário e buscar as funções habilitadas
        $funcoes = [];
        if (session('is_funcionario') && session('funcionario_id')) {
            $funcionario = \App\Models\Funcionario::find(session('funcionario_id'));
            if ($funcionario && $funcionario->funcoes) {
                $funcoes = explode(',', $funcionario->funcoes);
                $funcoes = array_map('trim', $funcoes);
            }
            $userRole = 'funcionario';
        }
        
        $menuItems = [
            [
                "name" => "Home",
                "path" => route('dashboard'),
                "icon" => "solar:home-smile-angle-outline",
                "activeOn" => ["master", "home"]
            ],
            [
                "name" => "Financeiro & Caixa",
                "path" => "javascript:void(0)",
                "icon" => "mdi:cash-register",
                "activeOn" => ["pdv", "contas_pagar", "financeiro_pdv", "relatorios_pdv", "controle_estoque", "lancamentos_pdv"],
                "group_title" => [
                    [
                        "name" => "Controle de Caixa",
                        "path" => route('pdv.index'),
                        "icon" => "mdi:cash-register",
                        "activeOn" => ["pdv"],
                        "funcao" => "pdv"
                    ],
                    [
                        "name" => "Minhas Despesas",
                        "path" => route('financeiro.contas-pagar'),
                        "icon" => "majesticons:money-line",
                        "activeOn" => ["contas_pagar", "cad_pagar", "editar_pagamento", "cad_pagar_simulador"],
                        "funcao" => "contas_pagar"
                    ],
                    [
                        "name" => "Resumo Financeiro",
                        "path" => "#",
                        "icon" => "mdi:currency-usd-circle-outline",
                        "activeOn" => ["financeiro_pdv"],
                        "funcao" => "financeiro_pdv"
                    ],
                    [
                        "name" => "Relatórios Financeiros",
                        "path" => "#",
                        "icon" => "mdi:chart-box-outline",
                        "activeOn" => ["relatorios_pdv"],
                        "funcao" => "relatorios"
                    ],
                    [
                        "name" => "Gestão de Produtos",
                        "path" => route('pdv.estoque.index'),
                        "icon" => "mdi:archive-outline",
                        "activeOn" => ["controle_estoque"],
                        "funcao" => "estoque"
                    ],
                    [
                        "name" => "Movimentações",
                        "path" => "#",
                        "icon" => "mdi:calendar-clock",
                        "activeOn" => ["lancamentos_pdv"],
                        "funcao" => "lancamentos"
                    ]
                ]
            ],
            [
                "name" => "Cobranças",
                "path" => "javascript:void(0)",
                "icon" => "majesticons:money-line",
                "activeOn" => ["clientes", "categorias", "contas_receber", "finalizados", "historico", "mensagens", "relatorio_whatsapp"],
                "group_title" => [
                    [
                        "name" => "Clientes",
                        "path" => route('clientes.index'),
                        "icon" => "solar:user-outline",
                        "activeOn" => ["clientes", "ver_cliente", "cad_cliente", "edit_cliente"],
                        "funcao" => "clientes"
                    ],
                    [
                        "name" => "Grupo/Categoria",
                        "path" => route('categorias.index'),
                        "icon" => "formkit:group",
                        "activeOn" => ["categorias", "cad_categoria", "edit_categoria"],
                        "funcao" => "categorias"
                    ],
                    [
                        "name" => "Contas a Receber",
                        "path" => route('financeiro.contas-receber'),
                        "icon" => "majesticons:money-plus-line",
                        "activeOn" => ["cad_contas", "contas_receber", "editar_mensalidade", "cad_contas_simulador", "ver_financeiro"],
                        "funcao" => "contas_receber"
                    ],
                    [
                        "name" => "Extrato de Pagamento",
                        "path" => route('financeiro.extrato'),
                        "icon" => "teenyicons:money-stack-outline",
                        "activeOn" => ["finalizados", "ver_financeiro_quitado"],
                        "funcao" => "finalizados"
                    ],
                    [
                        "name" => "Histórico de Transações",
                        "path" => route('historico.index'),
                        "icon" => "solar:history-outline",
                        "activeOn" => ["historico"],
                        "funcao" => "historico"
                    ],
                    [
                        "name" => "Notificações",
                        "path" => route('mensagens.index'),
                        "icon" => "solar:bell-outline",
                        "activeOn" => ["mensagens", "edit_mensagens"],
                        "funcao" => "mensagens"
                    ],
                    [
                        "name" => "Relatórios WhatsApp",
                        "path" => route('relatorios.whatsapp'),
                        "icon" => "solar:chart-2-outline",
                        "activeOn" => ["relatorio_whatsapp"],
                        "funcao" => "relatorios_whatsapp"
                    ]
                ]
            ],
            [
                "name" => "Marketing",
                "path" => "javascript:void(0)",
                "icon" => "material-symbols-light:campaign",
                "activeOn" => ["agendar_disparo", "woo_pedidos"],
                "group_title" => [
                    [
                        "name" => "Campanhas",
                        "path" => route('agendar-disparo.index'),
                        "icon" => "material-symbols-light:campaign",
                        "activeOn" => ["agendar_disparo", "ag_disp"],
                        "funcao" => "campanhas"
                    ],
                    [
                        "name" => "Woo Pedidos",
                        "path" => "#",
                        "icon" => "mdi:cart-outline",
                        "activeOn" => ["woo_pedidos"],
                        "funcao" => "woo_pedidos"
                    ]
                ]
            ],
            [
                "name" => "Administração",
                "path" => "javascript:void(0)",
                "icon" => "la:users-cog",
                "activeOn" => ["planos", "fornecedores_pdv", "cadastrar_funcionario", "relatorio_comissoes", "usuarios", "configuracoes"],
                "group_title" => [
                    [
                        "name" => "Planos",
                        "path" => route('planos.index'),
                        "icon" => "carbon:kubernetes-control-plane-node",
                        "activeOn" => ["planos", "cad_planos", "edit_planos"],
                        "funcao" => "planos"
                    ],
                    [
                        "name" => "Fornecedores",
                        "path" => "#",
                        "icon" => "mdi:truck-outline",
                        "activeOn" => ["fornecedores_pdv"],
                        "funcao" => "fornecedores"
                    ],
                    [
                        "name" => "Funcionários",
                        "path" => route('funcionarios.index'),
                        "icon" => "ph:users-four",
                        "activeOn" => ["cadastrar_funcionario"],
                        "funcao" => "funcionarios"
                    ],
                    [
                        "name" => "Relatório de Comissões",
                        "path" => route('comissoes.index'),
                        "icon" => "solar:wallet-money-outline",
                        "activeOn" => ["relatorio_comissoes"],
                        "funcao" => "relatorio_comissoes"
                    ]
                ]
            ]
        ];

        // Se for superadmin, adiciona "Usuários SAAS" no grupo Administração
        if ($userRole == "superadmin") {
            $menuItems[4]['group_title'][] = [
                "name" => "Usuários SAAS",
                "path" => route('usuarios.index'),
                "icon" => "la:users-cog",
                "activeOn" => ["usuarios", "cad_usuario", "edit_usuario", "painel_usuario"],
                "funcao" => "usuarios"
            ];
        }

        // Itens fixos (fora de dropdown)
        $menuItems[] = [
            "name" => "WhatsApp",
            "path" => route('whatsapp.index'),
            "icon" => "logos:whatsapp-icon",
            "activeOn" => ["whatsapp"],
            "funcao" => "whatsapp"
        ];

        $menuItems[] = [
            "name" => "Indicação",
            "path" => "#",
            "icon" => "solar:user-plus-outline",
            "activeOn" => ["indicacoes"]
        ];

        $menuItems[] = [
            "name" => "Tutoriais",
            "path" => route('tutoriais.index'),
            "icon" => "solar:book-outline",
            "activeOn" => ["tutoriais"],
            "funcao" => "tutoriais"
        ];

        $menuItems[] = [
            "name" => "Meu Perfil",
            "path" => route('perfil'),
            "icon" => "solar:user-outline",
            "activeOn" => ["perfil"],
            "funcao" => "perfil"
        ];

        $menuItems[] = [
            "name" => "Configurações",
            "path" => route('configuracoes.index'),
            "icon" => "solar:settings-outline",
            "activeOn" => ["configuracoes"],
            "funcao" => "configuracoes"
        ];

        $menuItems[] = [
            "name" => "Sair",
            "path" => route('logout'),
            "icon" => "solar:logout-outline",
            "activeOn" => ["sair"]
        ];

        return $menuItems;
    }
}
