# 🔐 Credenciais de Acesso - Gestor PRO

## Usuário Administrador

**Login:** `admin@admin.com`  
**Senha:** `admin123`  
**Tipo:** Administrador Master (tipo 1)  
**Status:** Ativo  
**Assinatura:** Vitalícia (31/12/2099)

---

## 🔧 Comandos Úteis

### Resetar Senha do Admin
```bash
php artisan admin:reset-password
```

### Resetar Senha de Qualquer Usuário
```bash
php artisan admin:reset-password email@exemplo.com novasenha123
```

### Criar/Atualizar Admin
```bash
php artisan db:seed --class=AdminSeeder
```

### Limpar Caches
```bash
php artisan cache:clear
php artisan config:clear
php artisan view:clear
php artisan route:clear
```

---

## 📝 Notas Importantes

1. **Novos Usuários**: Quando um novo usuário se registra, ele recebe:
   - Tipo: 3 (Usuário comum)
   - Status: 1 (Ativo)
   - Assinatura: 30 dias de trial

2. **Tipos de Usuário**:
   - `1` = Administrador Master (acesso total, sem verificação de assinatura)
   - `2` = Revendedor (sem verificação de assinatura)
   - `3` = Usuário Comum (precisa de assinatura válida)

3. **Sistema de Senha**: O sistema usa SHA1 para compatibilidade com o sistema antigo

4. **Middlewares Ativos**:
   - `auth` - Verifica se o usuário está autenticado
   - `check.license` - Verifica licença do domínio (permite acesso em caso de erro)
   - `check.subscription` - Verifica assinatura (não aplica para admin/revendedor)
   - `check.admin` - Verifica se é admin (tipo 1)

---

## 🚀 Iniciar Servidor

```bash
php artisan serve
```

Acesse: http://localhost:8000

---

## ⚠️ Troubleshooting

### Não consigo fazer login
1. Verifique se o banco de dados está conectado
2. Execute: `php artisan admin:reset-password`
3. Limpe os caches: `php artisan cache:clear && php artisan config:clear`
4. Tente novamente com: `admin@admin.com` / `admin123`

### Erro ao criar nova conta
1. Verifique se o email já não está cadastrado
2. A senha deve ter no mínimo 6 caracteres
3. Confirme a senha corretamente

### Redirecionado após login
1. Verifique se o middleware `check.license` está permitindo acesso
2. Verifique se a assinatura está válida (admins não precisam)
3. Verifique os logs em `storage/logs/laravel.log`

